/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.udp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.network.udp.AbstractNetworkClient;

public class UdpNetworkClient
extends AbstractNetworkClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(UdpNetworkClient.class);

    @Override
    DatagramSocket openSocket() throws IOException {
        DatagramSocket socket;
        if (this.getLocalPort() == null || this.getLocalPort() < 1) {
            LOGGER.debug("Listening on UDP on random port");
            socket = new DatagramSocket();
        } else {
            LOGGER.debug("Listening on UDP on port {}", (Object)this.getLocalPort());
            socket = new DatagramSocket(this.getLocalPort());
        }
        if (this.getAddress() != null && this.getPort() != null) {
            LOGGER.debug("Connecting to UDP on address [{}]:{}", (Object)this.getAddress(), (Object)this.getPort());
            socket.connect(InetAddress.getByName(this.getAddress()), this.getPort());
        }
        return socket;
    }
}

