/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.monitor;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.monitor.LockStatus;
import si.nevensrok.common.monitor.MonitorLock;
import si.nevensrok.common.monitor.MonitorLockException;

public abstract class AbstractMonitorLock
implements MonitorLock {
    private static final Logger log = LoggerFactory.getLogger(AbstractMonitorLock.class);
    private long monitorAcquireSleepTime = 500L;

    public void setMonitorAcquireSleepTime(long monitorAcquireSleepTime) {
        this.monitorAcquireSleepTime = monitorAcquireSleepTime;
    }

    @Override
    public void acquireMonitor(String monitor) throws MonitorLockException {
        this.acquireMonitor(monitor, null, -1L);
    }

    @Override
    public void acquireMonitor(String monitor, long maxWaitTime) throws MonitorLockException {
        this.acquireMonitor(monitor, null, maxWaitTime);
    }

    @Override
    public void acquireMonitor(String monitor, Date lockDeadline) throws MonitorLockException {
        this.acquireMonitor(monitor, lockDeadline, -1L);
    }

    @Override
    public void acquireMonitor(String monitor, Date lockDeadline, long maxWaitTime) throws MonitorLockException {
        if (log.isTraceEnabled()) {
            log.trace("Acquiring monitor lock [{}] with deadline [{}] with acquire timeout of [{}]ms", new Object[]{monitor, lockDeadline, maxWaitTime});
        }
        long waitUntil = -1L;
        if (maxWaitTime >= 0L) {
            waitUntil = System.currentTimeMillis() + maxWaitTime;
        }
        while (true) {
            this.removeExpiredLocks();
            if (this.addLock(monitor, lockDeadline)) break;
            if (waitUntil >= 0L && waitUntil < System.currentTimeMillis()) {
                throw new MonitorLockException("Couldn't acquire monitor lock in given time");
            }
            try {
                Thread.sleep(this.monitorAcquireSleepTime);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void releaseMonitor(String monitor) throws MonitorLockException {
        this.removeLock(monitor);
    }

    @Override
    public boolean isMonitorFree(String monitor) throws MonitorLockException {
        LockStatus lockStatus = this.getLockStatus(monitor);
        if (lockStatus == null) {
            return true;
        }
        Date date = lockStatus.getLockDeadline();
        if (date == null) {
            return false;
        }
        return date.getTime() < System.currentTimeMillis();
    }

    public abstract boolean addLock(String var1, Date var2);

    public abstract void removeLock(String var1);

    public abstract void removeExpiredLocks();

    public abstract LockStatus getLockStatus(String var1);
}

