/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.bytes;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import si.nevensrok.common.buffer.WriteByteBuffer;
import si.nevensrok.common.bytes.ByteBlock;
import si.nevensrok.common.bytes.FileByteBlockException;

public class FileByteBlock
implements ByteBlock {
    private static final Charset UTF8 = Charset.forName("UTF8");
    private RandomAccessFile randomAccessFile;

    public FileByteBlock(File file) throws IOException {
        this(file, false);
    }

    public FileByteBlock(File file, boolean synchronousWrite) throws IOException {
        this.randomAccessFile = synchronousWrite ? new RandomAccessFile(file, "rwd") : new RandomAccessFile(file, "rw");
    }

    public synchronized void close() {
        if (this.randomAccessFile != null) {
            try {
                this.randomAccessFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.randomAccessFile = null;
        }
    }

    @Override
    public long getSize() {
        try {
            return this.randomAccessFile.length();
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public void clear() {
        try {
            this.randomAccessFile.setLength(0L);
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized void setPosition(long position) {
        try {
            this.randomAccessFile.seek(position);
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized void changePositionBy(long positionDifference) {
        try {
            this.randomAccessFile.seek(this.randomAccessFile.getFilePointer() + positionDifference);
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized long getCurrentPosition() {
        try {
            return this.randomAccessFile.getFilePointer();
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized byte readBit() {
        try {
            return (byte)(this.randomAccessFile.readByte() & 1);
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized void writeBit(byte bit) {
        try {
            this.randomAccessFile.write(bit & 1);
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized boolean readBoolean() {
        try {
            return this.randomAccessFile.readByte() != 0;
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized void writeBoolean(boolean value) {
        try {
            this.randomAccessFile.write(value ? 1 : 0);
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized void writeByte(byte b) {
        try {
            this.randomAccessFile.write(b);
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized void writeByte(int b) {
        try {
            this.randomAccessFile.write(b);
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized byte readByte() {
        try {
            return this.randomAccessFile.readByte();
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized int readUnsignedByte() {
        try {
            return this.randomAccessFile.readByte() & 0xFF;
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized void writeUnsignedByte(int b) {
        try {
            this.randomAccessFile.write(b);
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized short readShort() {
        try {
            short value = (short)(this.randomAccessFile.readByte() << 8 & 0xFF00);
            value = (short)(value + (this.randomAccessFile.readByte() & 0xFF));
            return value;
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized void writeShort(short b) {
        try {
            this.randomAccessFile.write(b >> 8 & 0xFF);
            this.randomAccessFile.write(b & 0xFF);
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized int readUnsignedShort() {
        try {
            int value = this.randomAccessFile.readByte() << 8 & 0xFF00;
            return value += this.randomAccessFile.readByte() & 0xFF;
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized void writeUnsignedShort(int b) {
        try {
            this.randomAccessFile.write(b >> 8 & 0xFF);
            this.randomAccessFile.write(b & 0xFF);
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized int readInt() {
        try {
            int value = this.randomAccessFile.readByte() << 24 & 0xFF000000;
            value += this.randomAccessFile.readByte() << 16 & 0xFF0000;
            value += this.randomAccessFile.readByte() << 8 & 0xFF00;
            return value += this.randomAccessFile.readByte() & 0xFF;
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized void writeInt(int b) {
        try {
            this.randomAccessFile.write(b >> 24 & 0xFF);
            this.randomAccessFile.write(b >> 16 & 0xFF);
            this.randomAccessFile.write(b >> 8 & 0xFF);
            this.randomAccessFile.write(b & 0xFF);
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized long readUnsignedInt() {
        try {
            long value = (long)this.randomAccessFile.readByte() << 24 & 0xFF000000L;
            value += (long)this.randomAccessFile.readByte() << 16 & 0xFF0000L;
            value += (long)this.randomAccessFile.readByte() << 8 & 0xFF00L;
            return value += (long)(this.randomAccessFile.readByte() & 0xFF);
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized void writeUnsignedInt(long b) {
        try {
            this.randomAccessFile.write((int)(b >> 24 & 0xFFL));
            this.randomAccessFile.write((int)(b >> 16 & 0xFFL));
            this.randomAccessFile.write((int)(b >> 8 & 0xFFL));
            this.randomAccessFile.write((int)(b & 0xFFL));
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized long readLong() {
        try {
            long value = (long)this.randomAccessFile.readByte() << 56 & 0xFF00000000000000L;
            value += (long)this.randomAccessFile.readByte() << 48 & 0xFF000000000000L;
            value += (long)this.randomAccessFile.readByte() << 40 & 0xFF0000000000L;
            value += (long)this.randomAccessFile.readByte() << 32 & 0xFF00000000L;
            value += (long)this.randomAccessFile.readByte() << 24 & 0xFF000000L;
            value += (long)this.randomAccessFile.readByte() << 16 & 0xFF0000L;
            value += (long)this.randomAccessFile.readByte() << 8 & 0xFF00L;
            return value += (long)(this.randomAccessFile.readByte() & 0xFF);
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized void writeLong(long b) {
        try {
            this.randomAccessFile.write((int)(b >> 56 & 0xFFL));
            this.randomAccessFile.write((int)(b >> 48 & 0xFFL));
            this.randomAccessFile.write((int)(b >> 40 & 0xFFL));
            this.randomAccessFile.write((int)(b >> 32 & 0xFFL));
            this.randomAccessFile.write((int)(b >> 24 & 0xFFL));
            this.randomAccessFile.write((int)(b >> 16 & 0xFFL));
            this.randomAccessFile.write((int)(b >> 8 & 0xFFL));
            this.randomAccessFile.write((int)(b & 0xFFL));
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized float readFloat() {
        int n = this.readInt();
        return Float.intBitsToFloat(n);
    }

    @Override
    public synchronized void writeFloat(float b) {
        this.writeInt(Float.floatToIntBits(b));
    }

    @Override
    public synchronized double readDouble() {
        long n = this.readLong();
        return Double.longBitsToDouble(n);
    }

    @Override
    public synchronized void writeDouble(double b) {
        this.writeLong(Double.doubleToLongBits(b));
    }

    @Override
    public synchronized byte[] readBytes(int length) {
        byte[] bytes = new byte[length];
        this.readBytes(bytes);
        return bytes;
    }

    @Override
    public synchronized void readBytes(byte[] buffer) {
        try {
            this.randomAccessFile.read(buffer);
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized void readBytes(byte[] buffer, int offset, int length) {
        try {
            this.randomAccessFile.read(buffer, offset, length);
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized void writeBytes(byte[] buffer) {
        try {
            this.randomAccessFile.write(buffer);
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized void writeBytes(byte[] buffer, int offset, int length) {
        try {
            this.randomAccessFile.write(buffer, offset, length);
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized char readAsciiCharacter() {
        try {
            return (char)this.randomAccessFile.readByte();
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized void writeAsciiCharacter(char b) {
        try {
            this.randomAccessFile.write(b);
        }
        catch (IOException e) {
            throw new FileByteBlockException(e);
        }
    }

    @Override
    public synchronized char readUtf8Character() {
        int n = this.readUnsignedByte();
        if (n <= 127) {
            return (char)n;
        }
        if (n >= 192 && n <= 223) {
            int n2 = this.readUnsignedByte();
            if (n2 >= 128 && n2 <= 191) {
                return new String(new byte[]{(byte)n, (byte)n2}, UTF8).charAt(0);
            }
        } else if (n >= 224 && n <= 239) {
            int n2 = this.readUnsignedByte();
            int n3 = this.readUnsignedByte();
            if (n2 >= 128 && n2 <= 191 && n3 >= 128 && n3 <= 191) {
                return new String(new byte[]{(byte)n, (byte)n2, (byte)n3}, UTF8).charAt(0);
            }
        } else if (n >= 240 && n <= 247) {
            int n2 = this.readUnsignedByte();
            int n3 = this.readUnsignedByte();
            int n4 = this.readUnsignedByte();
            if (n2 >= 128 && n2 <= 191 && n3 >= 128 && n3 <= 191 && n4 >= 128 && n4 <= 191) {
                return new String(new byte[]{(byte)n, (byte)n2, (byte)n3, (byte)n4}, UTF8).charAt(0);
            }
        }
        throw new IllegalStateException("Unknown UTF8 character");
    }

    @Override
    public synchronized void writeUtf8Character(char b) {
        if (b <= '\u007f') {
            this.writeByte(b);
        } else {
            byte[] bytes = new String(new char[]{b}).getBytes(UTF8);
            this.writeBytes(bytes);
        }
    }

    @Override
    public synchronized String readAsciiString() {
        int n;
        StringBuilder value = new StringBuilder();
        while ((n = this.readUnsignedByte()) != 0) {
            value.append((char)n);
        }
        return value.toString();
    }

    @Override
    public synchronized void writeAsciiString(String b) {
        for (int i = 0; i < b.length(); ++i) {
            char c = b.charAt(i);
            this.writeAsciiCharacter(c);
        }
        this.writeByte(0);
    }

    @Override
    public synchronized String readUtf8String() {
        int n;
        WriteByteBuffer buffer = new WriteByteBuffer();
        while ((n = this.readUnsignedByte()) != 0) {
            buffer.add((byte)n);
        }
        return new String(buffer.getBuffer(), 0, buffer.getLength(), UTF8);
    }

    @Override
    public synchronized void writeUtf8String(String b) {
        byte[] bytes = b.getBytes(UTF8);
        this.writeBytes(bytes);
        this.writeByte(0);
    }
}

