/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.logging;

import java.io.StringWriter;
import org.apache.log4j.Layout;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import si.nevensrok.common.logging.AbstractBackgroundAppender;
import si.nevensrok.common.logging.LogItem;

public class XMPPAppender
extends AbstractBackgroundAppender {
    protected String hostname;
    protected int port = 5222;
    protected String username;
    protected String password;
    protected String users = null;
    private XMPPConnection connection;

    @Override
    public void connect() {
    }

    @Override
    public void disconnect() {
        block3: {
            try {
                if (this.connection != null) {
                    this.connection.disconnect();
                }
            }
            catch (Exception e) {
                if (!this.isDebug()) break block3;
                e.printStackTrace();
            }
        }
        this.connection = null;
    }

    @Override
    public void logItem(LogItem logItem) {
        try {
            String[] s;
            XMPPConnection connection = this.getConnection();
            StringWriter writer = new StringWriter();
            writer.write("Log message on server ");
            writer.write(logItem.getMachineHostname());
            writer.write(": ");
            writer.write(this.getLayout().format(logItem.getLoggingEvent()).trim());
            if (this.layout.ignoresThrowable() && (s = logItem.getLoggingEvent().getThrowableStrRep()) != null) {
                int len = s.length;
                for (int i = 0; i < len; ++i) {
                    writer.write(Layout.LINE_SEP);
                    writer.write(s[i]);
                }
            }
            String message = writer.toString();
            ChatManager chatManager = connection.getChatManager();
            for (String sendToUser : this.users.split("[,;]")) {
                Chat chat = chatManager.createChat(sendToUser, new MessageListener(){

                    public void processMessage(Chat chat, Message message) {
                    }
                });
                chat.sendMessage(message);
            }
        }
        catch (Exception e) {
            if (this.isDebug()) {
                e.printStackTrace();
            }
            this.disconnect();
        }
    }

    @Override
    public boolean requiresLayout() {
        return true;
    }

    private XMPPConnection getConnection() {
        block4: {
            if (this.isClosed()) {
                return null;
            }
            if (this.connection == null) {
                try {
                    ConnectionConfiguration connectionConfiguration = new ConnectionConfiguration(this.hostname, this.port);
                    connectionConfiguration.setSASLAuthenticationEnabled(true);
                    connectionConfiguration.setSecurityMode(ConnectionConfiguration.SecurityMode.disabled);
                    this.connection = new XMPPConnection(connectionConfiguration);
                    this.connection.connect();
                    this.connection.login(this.username, this.password);
                }
                catch (Exception e) {
                    if (!this.isDebug()) break block4;
                    e.printStackTrace();
                }
            }
        }
        return this.connection;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUsers(String users) {
        this.users = users;
    }
}

