/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.tls.TlsClient;
import org.bouncycastle.tls.TlsClientProtocol;
import si.nevensrok.common.network.tcp.CustomTlsClient;
import si.nevensrok.common.ssl.BcCertificateHostnameVerifier;
import si.nevensrok.common.ssl.BcHostnameVerifier;
import si.nevensrok.common.ssl.BcKeyManager;
import si.nevensrok.common.ssl.BcSSLSocket;
import si.nevensrok.common.ssl.BcTrustManager;
import si.nevensrok.common.ssl.SystemTrustStore;

public class BcSSLSocketFactory
extends SSLSocketFactory {
    private int connectTimeout = 10000;
    private BcKeyManager bcKeyManager;
    private BcTrustManager bcTrustManager;
    private BcHostnameVerifier bcHostnameVerifier;

    public BcSSLSocketFactory() {
        this(null, SystemTrustStore.getSystemBcTrustManager(), new BcCertificateHostnameVerifier());
    }

    public BcSSLSocketFactory(BcTrustManager bcTrustManager) {
        this(null, bcTrustManager, new BcCertificateHostnameVerifier());
    }

    public BcSSLSocketFactory(BcKeyManager bcKeyManager, BcTrustManager bcTrustManager) {
        this(bcKeyManager, bcTrustManager, new BcCertificateHostnameVerifier());
    }

    public BcSSLSocketFactory(BcKeyManager bcKeyManager, BcTrustManager bcTrustManager, BcHostnameVerifier bcHostnameVerifier) {
        this.bcKeyManager = bcKeyManager;
        this.bcTrustManager = bcTrustManager;
        this.bcHostnameVerifier = bcHostnameVerifier;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public BcKeyManager getBcKeyManager() {
        return this.bcKeyManager;
    }

    public BcTrustManager getBcTrustManager() {
        return this.bcTrustManager;
    }

    public BcHostnameVerifier getBcHostnameVerifier() {
        return this.bcHostnameVerifier;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return new String[0];
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return new String[0];
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        CustomTlsClient tlsClient = new CustomTlsClient();
        tlsClient.setKeyManager(this.getBcKeyManager());
        tlsClient.setTrustManager(this.getBcTrustManager());
        tlsClient.setHostname(host);
        TlsClientProtocol tlsClientProtocol = new TlsClientProtocol(inputStream, outputStream);
        tlsClientProtocol.connect((TlsClient)tlsClient);
        if (tlsClient.isSslSessionValid()) {
            Certificate certificate = Certificate.getInstance((Object)tlsClient.getServerCertificate().getEncoded());
            if (!this.getBcHostnameVerifier().verify(host, certificate)) {
                throw new IOException("Hostname verification failed");
            }
            return new BcSSLSocket(tlsClient, tlsClientProtocol, socket, autoClose);
        }
        throw new IOException("Ssl session is invalid");
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.createSocket(host, port, null, 0);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        return this.createSocket(InetAddress.getByName(host), port, localAddress, localPort);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.createSocket(host, port, null, 0);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        InetSocketAddress socketAddress = new InetSocketAddress(address, port);
        Socket socket = new Socket();
        if (localAddress != null) {
            if (localPort > 0) {
                socket.bind(new InetSocketAddress(localAddress, localPort));
            } else {
                socket.bind(new InetSocketAddress(localAddress, 0));
            }
        }
        socket.connect(socketAddress, this.connectTimeout);
        return this.createSocket(socket, address.getHostName(), port, true);
    }
}

