/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.restclient;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import si.nevensrok.common.restclient.RestApiException;
import si.nevensrok.common.restclient.RestApiResponseException;
import si.nevensrok.common.restclient.RestClient;
import si.nevensrok.common.restclient.RestClientUtil;
import si.nevensrok.common.restclient.RestRequest;
import si.nevensrok.common.restclient.RestResponse;
import si.nevensrok.common.utils.StringUtil;

public class XmlRestClient
extends RestClient {
    private String mimeType = "application/xml";
    private String charset = "utf8";

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public <V> void executeAsXml(String method, String url) {
        this.executeAsXml(method, url, null, null, null);
    }

    public <K> void executeAsXml(String method, String url, K body) {
        this.executeAsXml(method, url, body, null, null);
    }

    public <K> void executeAsXml(String method, String url, K body, Map<String, String> queryParameters) {
        this.executeAsXml(method, url, body, queryParameters, null);
    }

    public <K> void executeAsXml(String method, String url, K body, Map<String, String> queryParameters, Map<String, String> headers) {
        RestResponse restResponse;
        RestRequest restRequest = new RestRequest();
        restRequest.setMethod(method);
        restRequest.setUrl(url);
        if (queryParameters != null) {
            for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
                restRequest.setQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                restRequest.setHeader(entry.getKey(), entry.getValue());
            }
        }
        if (body != null) {
            String contentType = this.getContentType();
            String charset = RestClientUtil.extractCharset(contentType);
            if (StringUtil.isEmpty((String)charset)) {
                charset = "utf8";
            }
            restRequest.setContentType(contentType);
            try {
                StringWriter buffer = new StringWriter();
                this.getMarshaller(body.getClass()).marshal(body, (Result)new StreamResult(buffer));
                String xml = buffer.toString();
                restRequest.setBody(xml.getBytes(charset));
            }
            catch (Exception e) {
                throw new RestApiException("Error serializing xml", e);
            }
        }
        if (!(restResponse = this.execute(restRequest)).isSuccessful()) {
            throw new RestApiResponseException("Error response code received " + restResponse.getResponseCode(), restResponse.getResponseCode());
        }
    }

    public <V> V executeAndReadAsXml(String method, String url, Class<V> responseClass) {
        return this.executeAndReadAsXml(method, url, null, null, null, responseClass);
    }

    public <K, V> V executeAndReadAsXml(String method, String url, K body, Class<V> responseClass) {
        return this.executeAndReadAsXml(method, url, body, null, null, responseClass);
    }

    public <K, V> V executeAndReadAsXml(String method, String url, K body, Map<String, String> queryParameters, Class<V> responseClass) {
        return this.executeAndReadAsXml(method, url, body, queryParameters, null, responseClass);
    }

    public <K, V> V executeAndReadAsXml(String method, String url, K body, Map<String, String> queryParameters, Map<String, String> headers, Class<V> responseClass) {
        RestResponse restResponse;
        RestRequest restRequest = new RestRequest();
        restRequest.setMethod(method);
        restRequest.setUrl(url);
        if (queryParameters != null) {
            for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
                restRequest.setQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                restRequest.setHeader(entry.getKey(), entry.getValue());
            }
        }
        if (body != null) {
            String contentType = this.getContentType();
            String charset = RestClientUtil.extractCharset(contentType);
            if (StringUtil.isEmpty((String)charset)) {
                charset = "utf8";
            }
            restRequest.setContentType(contentType);
            try {
                StringWriter buffer = new StringWriter();
                this.getMarshaller(body.getClass()).marshal(body, (Result)new StreamResult(buffer));
                String xml = buffer.toString();
                restRequest.setBody(xml.getBytes(charset));
            }
            catch (Exception e) {
                throw new RestApiException("Error serializing xml", e);
            }
        }
        if (!(restResponse = this.execute(restRequest)).isSuccessful()) {
            throw new RestApiResponseException("Error response code received " + restResponse.getResponseCode(), restResponse.getResponseCode());
        }
        if (!this.acceptResponseContentType(restResponse.getContentType())) {
            throw new RestApiException("Invalid response content type: '" + restResponse.getContentType() + "'");
        }
        if (restResponse.getBody() == null || restResponse.getBody().length == 0) {
            return null;
        }
        try {
            String responseCharset = restResponse.getCharset();
            if (StringUtil.isEmpty((String)responseCharset)) {
                responseCharset = "utf8";
            }
            String xml = new String(restResponse.getBody(), responseCharset);
            Object responseBody = this.getUnmarshaller(responseClass).unmarshal((Source)new StreamSource(new StringReader(xml)));
            return (V)responseBody;
        }
        catch (Exception e) {
            throw new RestApiException("Error parsing response body as xml", e);
        }
    }

    private boolean acceptResponseContentType(String contentType) {
        if (StringUtil.isEmpty((String)contentType)) {
            return false;
        }
        if (contentType.toLowerCase().startsWith("application/xml")) {
            return true;
        }
        return contentType.toLowerCase().startsWith("text/xml");
    }

    public Marshaller getMarshaller(Class<?> clazz) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)false);
        return marshaller;
    }

    public Unmarshaller getUnmarshaller(Class<?> clazz) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return unmarshaller;
    }

    public String getContentType() {
        if (StringUtil.isNotEmpty((String)this.getMimeType()) && StringUtil.isNotEmpty((String)this.getCharset())) {
            return this.getMimeType() + "; charset=" + this.getCharset();
        }
        if (StringUtil.isEmpty((String)this.getMimeType()) && StringUtil.isNotEmpty((String)this.getCharset())) {
            return "application/xml; charset=" + this.getCharset();
        }
        if (StringUtil.isNotEmpty((String)this.getMimeType()) && StringUtil.isEmpty((String)this.getCharset())) {
            return this.getMimeType() + "; charset=utf8";
        }
        return "application/xml; charset=utf8";
    }
}

