/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.jms;

import java.io.Serializable;
import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import si.nevensrok.common.jms.JmsMessageCoopier;

public class SimpleJmsMessageCoopier
implements JmsMessageCoopier {
    @Override
    public Message copyMessage(Session session, Message message) throws JMSException {
        TextMessage copy = null;
        if (message instanceof TextMessage) {
            TextMessage sourceMessage = (TextMessage)message;
            copy = session.createTextMessage(sourceMessage.getText());
        } else if (message instanceof BytesMessage) {
            BytesMessage sourceMessage = (BytesMessage)message;
            BytesMessage bytesMessage = session.createBytesMessage();
            byte[] data = new byte[(int)sourceMessage.getBodyLength()];
            sourceMessage.readBytes(data);
            bytesMessage.writeBytes(data);
            copy = bytesMessage;
        } else if (message instanceof MapMessage) {
            MapMessage sourceMessage = (MapMessage)message;
            MapMessage mapMessage = session.createMapMessage();
            Enumeration i = sourceMessage.getMapNames();
            while (i.hasMoreElements()) {
                String name = (String)i.nextElement();
                Object value = sourceMessage.getObject(name);
                mapMessage.setObject(name, value);
            }
            copy = mapMessage;
        } else if (message instanceof ObjectMessage) {
            ObjectMessage sourceMessage = (ObjectMessage)message;
            Serializable obj = sourceMessage.getObject();
            copy = session.createObjectMessage(obj);
        } else {
            throw new IllegalArgumentException("Message type not supported: " + message.getClass().getName());
        }
        copy.setJMSCorrelationID(message.getJMSCorrelationID());
        copy.setJMSDeliveryMode(message.getJMSDeliveryMode());
        copy.setJMSExpiration(message.getJMSExpiration());
        copy.setJMSPriority(message.getJMSPriority());
        copy.setJMSReplyTo(message.getJMSReplyTo());
        return copy;
    }
}

