/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.dataimport;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import si.nevensrok.common.dataimport.FileContent;
import si.nevensrok.common.dataimport.FileLine;
import si.nevensrok.common.dataimport.FileReader;

public abstract class AbstractFileReader
implements FileReader {
    @Override
    public FileContent readFile(InputStream inputStream) {
        return this.readFile(inputStream, Integer.MAX_VALUE);
    }

    @Override
    public FileContent readFile(InputStream inputStream, int maximumLines) {
        try {
            this.init(inputStream);
            LinkedHashMap<Integer, String> headers = new LinkedHashMap<Integer, String>();
            LinkedList<FileLine> lines = new LinkedList<FileLine>();
            String[] line = this.readLine();
            for (int lineNumber = 0; line != null && lineNumber <= maximumLines; ++lineNumber) {
                if (lineNumber == 0) {
                    for (int i = 0; i < line.length; ++i) {
                        headers.put(i, line[i]);
                    }
                } else {
                    lines.add(new FileLine(line));
                }
                line = this.readLine();
            }
            this.close();
            return new FileContent(new LinkedList<String>(headers.values()), lines);
        }
        catch (Exception e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RuntimeException("Error while reading file", e);
        }
    }

    public abstract void init(InputStream var1) throws Exception;

    public abstract void close() throws Exception;

    public abstract String[] readLine() throws Exception;
}

