/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.convertor;

import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.convertor.MediaConvertorJob;

public class FfmpegMediaConvertorJob
implements MediaConvertorJob {
    private static final Logger log = LoggerFactory.getLogger(FfmpegMediaConvertorJob.class);
    private Process process;

    public FfmpegMediaConvertorJob(Process process) {
        this.process = process;
        final InputStream inputStream = process.getInputStream();
        Thread inputReaderThread = new Thread(){

            @Override
            public void run() {
                try {
                    int n = inputStream.read();
                    while (n >= 0) {
                        n = inputStream.read();
                    }
                }
                catch (Exception e) {
                    log.debug("Error reading from input stream", (Throwable)e);
                }
            }
        };
        inputReaderThread.setDaemon(true);
        inputReaderThread.start();
        final InputStream errorStream = process.getErrorStream();
        Thread errorReaderThread = new Thread(){

            @Override
            public void run() {
                try {
                    int n = errorStream.read();
                    while (n >= 0) {
                        n = errorStream.read();
                    }
                }
                catch (Exception e) {
                    log.debug("Error reading from error stream", (Throwable)e);
                }
            }
        };
        errorReaderThread.setDaemon(true);
        errorReaderThread.start();
    }

    public int getExitCode() throws InterruptedException {
        return this.process.waitFor();
    }

    @Override
    public void cancel() {
        this.process.destroy();
    }

    @Override
    public boolean isSuccessful() {
        try {
            return this.getExitCode() == 0;
        }
        catch (Exception e) {
            log.debug("Error waiting for exit code", (Throwable)e);
            return false;
        }
    }
}

