/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.buffer;

import java.io.Serializable;
import si.nevensrok.common.utils.ArrayUtil;

public class DynamicByteBuffer
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -746700500658843285L;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private byte[] buffer;
    private int startPos = 0;
    private int endPos = 0;
    private int maxSize = Integer.MAX_VALUE;

    public DynamicByteBuffer() {
        this(4096);
    }

    public DynamicByteBuffer(byte[] data) {
        this.buffer = data;
    }

    public DynamicByteBuffer(int initialSize) {
        this.buffer = new byte[initialSize];
    }

    public DynamicByteBuffer(int initialSize, int maxSize) {
        this(initialSize);
        this.maxSize = maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public synchronized void clear() {
        this.startPos = 0;
        this.endPos = 0;
        this.notifyAll();
    }

    public synchronized void close() {
        this.buffer = null;
        this.startPos = 0;
        this.endPos = 0;
        this.notifyAll();
    }

    public boolean isBufferFull() {
        return this.getAvailableCapacity() == 0;
    }

    public int getAvailableCapacity() {
        return this.getMaxSize() - this.getDataAvailable();
    }

    public boolean isBufferEmpty() {
        return this.getDataAvailable() == 0;
    }

    public int getDataAvailable() {
        return this.endPos - this.startPos;
    }

    public int getCurrentBufferSize() {
        return this.buffer.length;
    }

    private void rewind() {
        int len = this.getDataAvailable();
        for (int i = 0; i < len; ++i) {
            this.buffer[i] = this.buffer[i + this.startPos];
        }
        this.endPos -= this.startPos;
        this.startPos = 0;
    }

    public synchronized void add(byte b) {
        if (this.buffer == null) {
            throw new IllegalStateException("Buffer is closed");
        }
        if (this.isBufferFull()) {
            throw new IllegalStateException("Maximum buffer size reached");
        }
        if (this.endPos >= this.buffer.length) {
            if (this.startPos >= this.buffer.length / 2) {
                this.rewind();
            } else {
                byte[] newBuffer = new byte[Math.min(Math.max(4096, this.buffer.length * 2), this.maxSize)];
                System.arraycopy(this.buffer, this.startPos, newBuffer, 0, this.endPos - this.startPos);
                this.buffer = newBuffer;
                this.endPos -= this.startPos;
                this.startPos = 0;
            }
        }
        this.buffer[this.endPos++] = b;
        this.notifyAll();
    }

    public synchronized void add(byte[] bytes) {
        this.add(bytes, 0, bytes.length);
    }

    public synchronized void add(byte[] bytes, int offset, int length) {
        if (this.buffer == null) {
            throw new IllegalStateException("Buffer is closed");
        }
        if (length == 0) {
            return;
        }
        if (this.isBufferFull()) {
            throw new IllegalStateException("Maximum buffer size reached");
        }
        int neededLength = this.getDataAvailable() + length;
        if (neededLength > this.maxSize) {
            throw new IllegalStateException("Not enough space available in buffer");
        }
        if (this.endPos + length > this.buffer.length) {
            if (this.startPos >= this.buffer.length / 2) {
                this.rewind();
            } else {
                byte[] newBuffer = new byte[Math.min(Math.max(Math.max(4096, this.buffer.length * 2), neededLength), this.maxSize)];
                System.arraycopy(this.buffer, this.startPos, newBuffer, 0, this.endPos - this.startPos);
                this.buffer = newBuffer;
                this.endPos -= this.startPos;
                this.startPos = 0;
            }
        }
        System.arraycopy(bytes, offset, this.buffer, this.endPos, length);
        this.endPos += length;
        this.notifyAll();
    }

    public synchronized void addBlocking(byte b) throws InterruptedException {
        while (true) {
            if (this.buffer == null) {
                throw new IllegalStateException("Buffer is closed");
            }
            if (!this.isBufferFull()) break;
            this.wait();
        }
        if (this.endPos >= this.buffer.length) {
            if (this.startPos > 0) {
                this.rewind();
            } else {
                byte[] newBuffer = new byte[Math.min(Math.max(4096, this.buffer.length * 2), this.maxSize)];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.endPos);
                this.buffer = newBuffer;
            }
        }
        this.buffer[this.endPos++] = b;
        this.notifyAll();
    }

    public synchronized void addBlocking(byte[] bytes) throws InterruptedException {
        this.addBlocking(bytes, 0, bytes.length);
    }

    public synchronized void addBlocking(byte[] bytes, int offset, int length) throws InterruptedException {
        int neededLength;
        if (length == 0) {
            return;
        }
        while (true) {
            neededLength = this.getDataAvailable() + length;
            if (this.buffer == null) {
                throw new IllegalStateException("Buffer is closed");
            }
            if (neededLength <= this.maxSize) break;
            this.wait();
        }
        if (this.endPos + length > this.buffer.length) {
            if (this.startPos >= length) {
                this.rewind();
            } else {
                byte[] newBuffer = new byte[Math.min(Math.max(Math.max(4096, this.buffer.length * 2), neededLength), this.maxSize)];
                System.arraycopy(this.buffer, this.startPos, newBuffer, 0, this.endPos - this.startPos);
                this.buffer = newBuffer;
                this.endPos -= this.startPos;
                this.startPos = 0;
            }
        }
        System.arraycopy(bytes, offset, this.buffer, this.endPos, length);
        this.endPos += length;
        this.notifyAll();
    }

    public synchronized byte get() {
        if (this.buffer == null) {
            throw new IllegalStateException("Buffer is closed");
        }
        if (this.startPos >= this.endPos) {
            throw new IllegalStateException("Buffer is empty");
        }
        this.notifyAll();
        return this.buffer[this.startPos++];
    }

    public synchronized void get(byte[] data) {
        this.get(data, 0, data.length);
    }

    public synchronized void get(byte[] data, int offset, int length) {
        if (this.buffer == null) {
            throw new IllegalStateException("Buffer is closed");
        }
        if (length == 0) {
            return;
        }
        if (this.startPos >= this.endPos) {
            throw new IllegalStateException("Buffer is empty");
        }
        if (this.getDataAvailable() < length) {
            throw new IllegalStateException("Not enough data available in buffer");
        }
        System.arraycopy(this.buffer, this.startPos, data, offset, length);
        this.startPos += length;
        this.notifyAll();
    }

    public synchronized byte[] get(int length) {
        if (this.buffer == null) {
            throw new IllegalStateException("Buffer is closed");
        }
        if (length == 0) {
            return new byte[0];
        }
        if (this.startPos >= this.endPos) {
            throw new IllegalStateException("Buffer is empty");
        }
        if (this.getDataAvailable() < length) {
            throw new IllegalStateException("Not enough data available in buffer");
        }
        byte[] data = new byte[length];
        System.arraycopy(this.buffer, this.startPos, data, 0, length);
        this.startPos += length;
        this.notifyAll();
        return data;
    }

    public synchronized byte[] getAll() {
        return this.get(this.getDataAvailable());
    }

    public synchronized byte getBlocking() throws InterruptedException {
        while (true) {
            if (this.buffer == null) {
                throw new IllegalStateException("Buffer is closed");
            }
            if (this.startPos < this.endPos) break;
            this.wait();
        }
        this.notifyAll();
        return this.buffer[this.startPos++];
    }

    public synchronized void getBlocking(byte[] data) throws InterruptedException {
        this.get(data, 0, data.length);
    }

    public synchronized void getBlocking(byte[] data, int offset, int length) throws InterruptedException {
        if (length == 0) {
            return;
        }
        while (true) {
            if (this.buffer == null) {
                throw new IllegalStateException("Buffer is closed");
            }
            if (this.getDataAvailable() >= length) break;
            this.wait();
        }
        System.arraycopy(this.buffer, this.startPos, data, offset, length);
        this.startPos += length;
        this.notifyAll();
    }

    public synchronized byte[] getBlocking(int length) throws InterruptedException {
        if (length == 0) {
            return new byte[0];
        }
        while (true) {
            if (this.buffer == null) {
                throw new IllegalStateException("Buffer is closed");
            }
            if (this.getDataAvailable() >= length) break;
            this.wait();
        }
        byte[] data = new byte[length];
        System.arraycopy(this.buffer, this.startPos, data, 0, length);
        this.startPos += length;
        this.notifyAll();
        return data;
    }

    public synchronized byte[] getAllBlocking() throws InterruptedException {
        return this.getBlocking(this.getDataAvailable());
    }

    public synchronized void remove(int length) {
        if (length == 0) {
            return;
        }
        if (this.buffer == null) {
            throw new IllegalStateException("Buffer is closed");
        }
        if (this.startPos >= this.endPos) {
            throw new IllegalStateException("Buffer is empty");
        }
        if (this.getDataAvailable() < length) {
            throw new IllegalStateException("Not enough data available in buffer");
        }
        this.startPos += length;
        this.notifyAll();
    }

    public synchronized void removeBlocking(int length) throws InterruptedException {
        if (length == 0) {
            return;
        }
        while (true) {
            if (this.buffer == null) {
                throw new IllegalStateException("Buffer is closed");
            }
            if (this.getDataAvailable() >= length) break;
            this.wait();
        }
        this.startPos += length;
        this.notifyAll();
    }

    public synchronized void waitForData() throws InterruptedException {
        this.waitForData(1);
    }

    public synchronized void waitForData(int length) throws InterruptedException {
        if (length == 0) {
            return;
        }
        while (true) {
            if (this.buffer == null) {
                throw new IllegalStateException("Buffer is closed");
            }
            if (this.getDataAvailable() >= length) break;
            this.wait();
        }
        this.notifyAll();
    }

    public synchronized byte[] getCopyOfCurrentBuffer() {
        return ArrayUtil.subArray((byte[])this.buffer, (int)this.startPos, (int)(this.endPos - this.startPos));
    }

    public synchronized DynamicByteBuffer clone() {
        try {
            DynamicByteBuffer clone = (DynamicByteBuffer)super.clone();
            clone.buffer = ArrayUtil.copyArray((byte[])this.buffer);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Cloning failed", e);
        }
    }
}

