/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.streams;

import java.io.IOException;
import java.io.OutputStream;
import si.nevensrok.common.streams.DataOutputStream;

public class SplitterOutputStream
extends DataOutputStream {
    private static final int DATA_FULL = 0;
    private static final int DATA_INFO = 1;
    private static final int DATA_CONTENT = 2;
    private int indexCounter = Integer.MIN_VALUE;
    private int chunkSize;
    private long lastActivityAt = Long.MIN_VALUE;

    public SplitterOutputStream(OutputStream outputStream, int chunkSize) {
        super(outputStream);
        this.chunkSize = chunkSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData(byte[] data) throws IOException {
        int bytesToWrite;
        int dataId;
        if (data.length <= this.chunkSize) {
            SplitterOutputStream splitterOutputStream = this;
            synchronized (splitterOutputStream) {
                this.writeUnsignedByte(0);
                this.writeInt(data.length);
                this.write(data);
                this.flush();
                this.lastActivityAt = System.currentTimeMillis();
            }
        }
        SplitterOutputStream splitterOutputStream = this;
        synchronized (splitterOutputStream) {
            dataId = this.indexCounter++;
            this.writeUnsignedByte(1);
            this.writeInt(dataId);
            this.writeInt(data.length);
        }
        this.lastActivityAt = System.currentTimeMillis();
        for (int bytesWritten = 0; bytesWritten < data.length; bytesWritten += bytesToWrite) {
            bytesToWrite = Math.min(this.chunkSize, data.length - bytesWritten);
            SplitterOutputStream splitterOutputStream2 = this;
            synchronized (splitterOutputStream2) {
                this.writeUnsignedByte(2);
                this.writeInt(dataId);
                this.writeInt(bytesToWrite);
                this.write(data, bytesWritten, bytesToWrite);
            }
            this.lastActivityAt = System.currentTimeMillis();
        }
        SplitterOutputStream splitterOutputStream3 = this;
        synchronized (splitterOutputStream3) {
            this.flush();
        }
    }

    public long getLastActivityAt() {
        return this.lastActivityAt;
    }
}

