/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.qrcode.codes;

import java.io.Serializable;
import si.nevensrok.common.qrcode.QRCode;
import si.nevensrok.common.qrcode.QRCodeException;
import si.nevensrok.common.qrcode.QRCodeType;

public class QRWifiCode
implements QRCode,
Serializable {
    private static final long serialVersionUID = -8948739435526112563L;
    public static final int WEP = 1;
    public static final int WPA = 2;
    public static final int UNENCRYPTED = 3;
    private String ssid;
    private int wifiType;
    private String password;

    public QRWifiCode() {
    }

    public QRWifiCode(String ssid, int wifiType, String password) {
        this.ssid = ssid;
        this.wifiType = wifiType;
        this.password = password;
    }

    public String getSsid() {
        return this.ssid;
    }

    public void setSsid(String ssid) {
        this.ssid = ssid;
    }

    public int getWifiType() {
        return this.wifiType;
    }

    public void setWifiType(int wifiType) {
        this.wifiType = wifiType;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getCodeText() {
        StringBuilder text = new StringBuilder();
        text.append("WIFI:");
        text.append("S:");
        text.append(this.ssid);
        text.append(";");
        if (this.wifiType == 1) {
            text.append("T:WEP;");
        } else if (this.wifiType == 2) {
            text.append("T:WPA;");
        } else {
            text.append("T:nopass;");
        }
        if (this.password != null && !this.password.isEmpty()) {
            text.append("P:");
            text.append(this.password);
            text.append(";");
        }
        text.append(";");
        return text.toString();
    }

    @Override
    public QRCodeType getType() {
        return QRCodeType.WIFI;
    }

    @Override
    public void parseCode(String text) throws QRCodeException {
        try {
            if (!text.startsWith("WIFI:")) {
                throw new QRCodeException("Not a WIFI QR code!");
            }
            text = text.substring(5, text.length());
            for (String part : text.split(";")) {
                if (part.startsWith("S:")) {
                    this.ssid = part.substring(2, part.length());
                    continue;
                }
                if (part.startsWith("T:")) {
                    if (part.substring(2, part.length()).trim().equalsIgnoreCase("WEP")) {
                        this.wifiType = 1;
                        continue;
                    }
                    if (part.substring(2, part.length()).trim().equalsIgnoreCase("WPA")) {
                        this.wifiType = 2;
                        continue;
                    }
                    this.wifiType = 3;
                    continue;
                }
                if (!part.startsWith("P:")) continue;
                this.password = part.substring(2, part.length());
            }
        }
        catch (QRCodeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QRCodeException("Error while parsing QR code", e);
        }
    }

    public String toString() {
        return "QRWifiCode [ssid=" + this.ssid + ", wifiType=" + this.wifiType + ", password=" + this.password + "]";
    }
}

