/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.tcp;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import si.nevensrok.common.encryption.EncryptorDecryptor;
import si.nevensrok.common.network.tcp.TcpNetworkConnection;
import si.nevensrok.common.streams.EncryptedInputStream;
import si.nevensrok.common.streams.EncryptedOutputStream;

public class AesTcpNetworkConnection
extends TcpNetworkConnection {
    private EncryptorDecryptor encryptorDecryptor;
    private int bufferSize = 0x200000;

    public AesTcpNetworkConnection(Socket socket, EncryptorDecryptor encryptorDecryptor) throws Exception {
        super(socket);
        this.encryptorDecryptor = encryptorDecryptor;
    }

    @Override
    protected OutputStream openOutputStream(OutputStream outputStream) throws Exception {
        return new EncryptedOutputStream(outputStream, this.encryptorDecryptor, this.getBufferSize());
    }

    @Override
    protected InputStream openInputStream(InputStream inputStream) throws Exception {
        EncryptedInputStream encryptedInputStream = new EncryptedInputStream(inputStream, this.encryptorDecryptor);
        encryptedInputStream.setMaxMessageSize(this.getMaxMessageSize());
        return encryptedInputStream;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }
}

