/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.clusterlock;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.StringUtils;
import si.nevensrok.common.clusterlock.ClusterLock;
import si.nevensrok.common.clusterlock.ParameterName;
import si.nevensrok.common.lock.LockService;

@Aspect
public class ClusterLockAop
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ClusterLockAop.class);
    private ApplicationContext applicationContext;
    private LockService defaultLockService;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setDefaultLockService(LockService defaultLockService) {
        this.defaultLockService = defaultLockService;
    }

    public LockService getDefaultLockService() {
        return this.defaultLockService;
    }

    @Around(value="@annotation(si.nevensrok.common.clusterlock.ClusterLock)")
    public Object processMethodCall(ProceedingJoinPoint point) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        ClusterLock clusterLock = this.findClusterLockAnnotation(method);
        Lock lock = null;
        if (clusterLock != null) {
            LockService lockService = this.findLockService(clusterLock);
            String lockName = this.generateLockName(method, point.getArgs(), clusterLock);
            if (lockService != null) {
                lock = lockService.getLockByName(lockName);
            }
        }
        Throwable error = null;
        Object result = null;
        if (lock != null) {
            long acquireLockTimeout = clusterLock.acquireLockTimeout();
            if (acquireLockTimeout <= 0L) {
                lock.lock();
            } else if (!lock.tryLock(acquireLockTimeout, TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Error acquiering lock in " + acquireLockTimeout + " milliseconds");
            }
        }
        try {
            result = point.proceed();
        }
        catch (Throwable e) {
            error = e;
        }
        if (lock != null) {
            lock.unlock();
        }
        if (error != null) {
            throw error;
        }
        return result;
    }

    protected ClusterLock findClusterLockAnnotation(Method method) {
        for (Annotation annotation : method.getAnnotations()) {
            if (!(annotation instanceof ClusterLock)) continue;
            return (ClusterLock)annotation;
        }
        return null;
    }

    protected LockService findLockService(ClusterLock clusterLock) {
        String lockServiceName = clusterLock.lockService();
        if (!StringUtils.isEmpty((Object)lockServiceName)) {
            try {
                Object lockServiceBean = this.getApplicationContext().getBean(lockServiceName);
                if (lockServiceBean instanceof LockService) {
                    return (LockService)lockServiceBean;
                }
                log.warn("Bean '{}' does not implement LockService interface", (Object)lockServiceName);
            }
            catch (NoSuchBeanDefinitionException e) {
                log.warn("Bean '{}' not found", (Object)lockServiceName);
            }
        }
        if (this.getDefaultLockService() != null) {
            return this.getDefaultLockService();
        }
        LockService bestCandidate = null;
        Map candidates = this.getApplicationContext().getBeansOfType(LockService.class);
        for (Map.Entry entry : candidates.entrySet()) {
            if ("LockService".equalsIgnoreCase((String)entry.getKey())) {
                bestCandidate = (LockService)entry.getValue();
                continue;
            }
            if (bestCandidate != null) continue;
            bestCandidate = (LockService)entry.getValue();
        }
        if (bestCandidate == null) {
            log.warn("Default lock service not found in application context");
        }
        return bestCandidate;
    }

    private String generateLockName(Method method, Object[] args, ClusterLock clusterLock) {
        StringBuilder lockName = new StringBuilder();
        lockName.append(method.getDeclaringClass().getName());
        lockName.append("->");
        lockName.append(method.getName());
        lockName.append("(");
        boolean firstParameter = true;
        for (Class<?> parameterClass : method.getParameterTypes()) {
            if (firstParameter) {
                firstParameter = false;
            } else {
                lockName.append(",");
            }
            lockName.append(parameterClass.getName());
        }
        lockName.append(")");
        String suffix = clusterLock.key();
        if (!StringUtils.isEmpty((Object)suffix)) {
            SpelExpressionParser expressionParser = new SpelExpressionParser();
            Expression expression = expressionParser.parseExpression(suffix);
            StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
            Parameter[] parameters = method.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                ParameterName parameterName = this.findParameterNameAnnotation(parameters[i]);
                if (parameterName != null) {
                    evaluationContext.setVariable(parameterName.value(), args[i]);
                }
                if (parameters[i].isNamePresent()) {
                    evaluationContext.setVariable("arg" + String.valueOf(i), args[i]);
                }
                evaluationContext.setVariable(parameters[i].getName(), args[i]);
            }
            Object value = expression.getValue((EvaluationContext)evaluationContext);
            String textValue = value != null ? value.toString() : "";
            lockName.append("->");
            lockName.append(textValue);
        }
        return lockName.toString();
    }

    protected ParameterName findParameterNameAnnotation(Parameter parameter) {
        for (Annotation annotation : parameter.getAnnotations()) {
            if (!(annotation instanceof ParameterName)) continue;
            return (ParameterName)annotation;
        }
        return null;
    }
}

