/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.streams;

import java.io.IOException;
import java.io.OutputStream;

public class ThrottledOutputStream
extends OutputStream {
    private static final long WINDOW_DURATION = 1000L;
    private OutputStream outputStream;
    private long bytesPerSecond;
    private long lastWindowStartedAt = 0L;
    private long bytesWrittenInCurrentWindow = 0L;

    public ThrottledOutputStream(OutputStream outputStream, long bytesPerSecond) {
        if (bytesPerSecond < 1L) {
            throw new IllegalArgumentException("Bytes per second must be value greater than 0");
        }
        this.outputStream = outputStream;
        this.bytesPerSecond = bytesPerSecond;
    }

    public long getBytesPerSecond() {
        return this.bytesPerSecond;
    }

    public void setBytesPerSecond(long bytesPerSecond) {
        this.bytesPerSecond = bytesPerSecond;
    }

    @Override
    public void write(int b) throws IOException {
        long currentTime = System.currentTimeMillis();
        long currentWindowLeftTime = 1000L - currentTime + this.lastWindowStartedAt;
        if (currentWindowLeftTime > 0L) {
            if (this.bytesWrittenInCurrentWindow >= this.bytesPerSecond) {
                try {
                    Thread.sleep(currentWindowLeftTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.lastWindowStartedAt = currentTime;
                this.bytesWrittenInCurrentWindow = 0L;
            }
        } else {
            this.lastWindowStartedAt = currentTime;
            this.bytesWrittenInCurrentWindow = 0L;
        }
        ++this.bytesWrittenInCurrentWindow;
        this.outputStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }
}

