/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.streams;

import java.io.IOException;
import java.io.InputStream;
import si.nevensrok.common.buffer.DynamicByteBuffer;

public class InputStreamBuffer
extends InputStream {
    private DynamicByteBuffer buffer;

    public InputStreamBuffer() {
        this.buffer = new DynamicByteBuffer();
    }

    public InputStreamBuffer(int initialSize) {
        this.buffer = new DynamicByteBuffer(initialSize);
    }

    public InputStreamBuffer(int initialSize, int maxSize) {
        this.buffer = new DynamicByteBuffer(initialSize, maxSize);
    }

    @Override
    public int read() throws IOException {
        try {
            if (this.buffer == null) {
                return -1;
            }
            return this.buffer.getBlocking() & 0xFF;
        }
        catch (InterruptedException e) {
            throw new IOException("Read was interrupted", e);
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.buffer == null) {
            return -1;
        }
        try {
            this.buffer.waitForData();
            int readDataCount = Math.min(this.buffer.getDataAvailable(), len);
            this.buffer.get(b, off, readDataCount);
            return readDataCount;
        }
        catch (InterruptedException e) {
            throw new IOException("Read was interrupted", e);
        }
        catch (IllegalStateException e) {
            return -1;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.buffer == null) {
            throw new IOException("Stream is closed");
        }
        int skipDataCount = Math.min(this.buffer.getDataAvailable(), (int)n);
        this.buffer.remove(skipDataCount);
        return skipDataCount;
    }

    @Override
    public int available() throws IOException {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.getDataAvailable();
    }

    @Override
    public void close() {
        if (this.buffer != null) {
            this.buffer.close();
            this.buffer = null;
        }
    }

    public int getAvailableCapacity() {
        return this.buffer.getAvailableCapacity();
    }

    public void addToBuffer(byte b) {
        if (this.buffer == null) {
            throw new IllegalStateException("Stream is closed");
        }
        this.buffer.add(b);
    }

    public void addToBuffer(byte[] data) {
        this.addToBuffer(data, 0, data.length);
    }

    public void addToBuffer(byte[] data, int offset, int length) {
        if (this.buffer == null) {
            throw new IllegalStateException("Stream is closed");
        }
        this.buffer.add(data, offset, length);
    }
}

