/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.streams;

import java.io.IOException;
import java.io.OutputStream;
import si.nevensrok.common.buffer.WriteByteBuffer;
import si.nevensrok.common.encryption.Encryptor;
import si.nevensrok.common.streams.DataOutputStream;

public class EncryptedOutputStream
extends OutputStream {
    private DataOutputStream outputStream;
    private Encryptor encryptor;
    private boolean closed = false;
    private WriteByteBuffer buffer;

    public EncryptedOutputStream(OutputStream outputStream, Encryptor encryptor, int bufferSize) {
        this.outputStream = new DataOutputStream(outputStream);
        this.encryptor = encryptor;
        this.buffer = new WriteByteBuffer(bufferSize, bufferSize);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        this.buffer.add((byte)b);
        if (this.buffer.isBufferFull()) {
            this.flush();
        }
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.buffer.getAvailableCapacity() >= len) {
            this.buffer.add(b, off, len);
        } else {
            int bytesToWrite;
            for (int bytesWritten = 0; bytesWritten < len; bytesWritten += bytesToWrite) {
                if (this.buffer.isBufferFull()) {
                    this.flush();
                }
                bytesToWrite = Math.min(this.buffer.getAvailableCapacity(), len - bytesWritten);
                this.buffer.add(b, off + bytesWritten, bytesToWrite);
            }
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.buffer.getLength() == 0) {
            return;
        }
        byte[] data = this.buffer.getByteArray();
        this.buffer.clear();
        data = this.encryptor.encrypt(data);
        this.outputStream.writeInt(data.length);
        this.outputStream.write(data);
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.closed = true;
        this.outputStream.close();
    }
}

