/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.executor;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import si.nevensrok.common.executor.FutureCompletedSpy;
import si.nevensrok.common.executor.FutureWrapper;
import si.nevensrok.common.executor.PriorityCallable;
import si.nevensrok.common.executor.PriorityExecutorService;
import si.nevensrok.common.executor.PriorityRunnable;
import si.nevensrok.common.executor.TaskExecutor;
import si.nevensrok.common.executor.TaskPriorityBlockingQueue;
import si.nevensrok.common.executor.TaskWrapper;
import si.nevensrok.common.threads.GroupThreadFactory;

public class ThreadPoolPriorityExecutor<P>
implements PriorityExecutorService<P> {
    private boolean active = true;
    private TaskPriorityBlockingQueue<P> queue;
    private TaskExecutor<P>[] taskExecutors;
    private long taskIndex = Long.MIN_VALUE;

    public ThreadPoolPriorityExecutor() {
        this(1);
    }

    public ThreadPoolPriorityExecutor(int threads) {
        this(threads, Integer.MAX_VALUE);
    }

    public ThreadPoolPriorityExecutor(int threads, int queueSize) {
        this(threads, queueSize, new GroupThreadFactory("ThreadPoolPriorityExecutor", false));
    }

    public ThreadPoolPriorityExecutor(int threads, String groupName) {
        this(threads, Integer.MAX_VALUE, new GroupThreadFactory(groupName, false));
    }

    public ThreadPoolPriorityExecutor(int threads, int queueSize, String groupName) {
        this(threads, queueSize, new GroupThreadFactory(groupName, false));
    }

    public ThreadPoolPriorityExecutor(int threads, int queueSize, ThreadFactory threadFactory) {
        if (threads < 1) {
            throw new IllegalArgumentException("Threads must be value equal to 1 or greater");
        }
        if (queueSize < 0) {
            throw new IllegalArgumentException("Queue size must be value equal to 0 or greater");
        }
        this.queue = new TaskPriorityBlockingQueue(queueSize);
        this.taskExecutors = new TaskExecutor[threads];
        for (int i = 0; i < this.taskExecutors.length; ++i) {
            this.taskExecutors[i] = new TaskExecutor<P>(this.queue, threadFactory);
        }
    }

    private synchronized long getNextTaskIndex() {
        return this.taskIndex++;
    }

    @Override
    public void shutdown() {
        if (!this.active) {
            return;
        }
        this.active = false;
        for (TaskExecutor<P> taskExecutor : this.taskExecutors) {
            taskExecutor.shutdownAfterEmptyQueue();
        }
    }

    @Override
    public List<PriorityRunnable<P>> shutdownNow() {
        this.active = false;
        for (TaskExecutor<P> taskExecutor : this.taskExecutors) {
            taskExecutor.shutdown();
        }
        LinkedList tasks = new LinkedList();
        this.queue.drainTo(tasks);
        LinkedList<PriorityRunnable<P>> leftoverRunnables = new LinkedList<PriorityRunnable<P>>();
        for (TaskWrapper taskWrapper : tasks) {
            if (!(taskWrapper.getTask() instanceof PriorityRunnable)) continue;
            leftoverRunnables.add((PriorityRunnable)taskWrapper.getTask());
        }
        return leftoverRunnables;
    }

    @Override
    public boolean isShutdown() {
        return !this.active;
    }

    @Override
    public boolean isTerminated() {
        for (TaskExecutor<P> taskExecutor : this.taskExecutors) {
            if (taskExecutor.isTerminated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.isTerminated()) {
            return true;
        }
        long waitUntil = System.currentTimeMillis() + unit.toMillis(timeout);
        while (!this.isTerminated()) {
            long waitTime = waitUntil - System.currentTimeMillis();
            if (waitTime <= 0L) {
                return false;
            }
            Thread.sleep(100L);
        }
        return this.isTerminated();
    }

    @Override
    public <T1> Future<T1> submit(PriorityCallable<T1, P> task) {
        if (!this.active) {
            throw new IllegalStateException("Executor is shut down");
        }
        FutureWrapper futureWrapper = new FutureWrapper(task.getPriority(), this.getNextTaskIndex(), task);
        if (!this.queue.offer(futureWrapper)) {
            throw new RejectedExecutionException("Queue is full");
        }
        return futureWrapper;
    }

    @Override
    public <T1> Future<T1> submit(PriorityRunnable<P> task, T1 result) {
        if (!this.active) {
            throw new IllegalStateException("Executor is shut down");
        }
        FutureWrapper futureWrapper = new FutureWrapper(task.getPriority(), this.getNextTaskIndex(), task, result);
        if (!this.queue.offer(futureWrapper)) {
            throw new RejectedExecutionException("Queue is full");
        }
        return futureWrapper;
    }

    @Override
    public Future<?> submit(PriorityRunnable<P> task) {
        if (!this.active) {
            throw new IllegalStateException("Executor is shut down");
        }
        FutureWrapper futureWrapper = new FutureWrapper(task.getPriority(), this.getNextTaskIndex(), task);
        if (!this.queue.offer(futureWrapper)) {
            throw new RejectedExecutionException("Queue is full");
        }
        return futureWrapper;
    }

    @Override
    public <T1> List<Future<T1>> invokeAll(Collection<? extends PriorityCallable<T1, P>> tasks) throws InterruptedException {
        if (!this.active) {
            throw new IllegalStateException("Executor is shut down");
        }
        LinkedList<Future<T1>> futureList = new LinkedList<Future<T1>>();
        for (PriorityCallable<T1, P> task : tasks) {
            futureList.add(this.submit(task));
        }
        return futureList;
    }

    @Override
    public <T1> List<Future<T1>> invokeAll(Collection<? extends PriorityCallable<T1, P>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        if (!this.active) {
            throw new IllegalStateException("Executor is shut down");
        }
        LinkedList<Future<T1>> futureList = new LinkedList<Future<T1>>();
        for (PriorityCallable<T1, P> task : tasks) {
            FutureWrapper futureWrapper = new FutureWrapper(task.getPriority(), this.getNextTaskIndex(), task);
            if (!this.queue.offer(futureWrapper, timeout, unit)) {
                throw new RejectedExecutionException("Queue is full");
            }
            futureList.add(futureWrapper);
        }
        return futureList;
    }

    @Override
    public <T1> T1 invokeAny(Collection<? extends PriorityCallable<T1, P>> tasks) throws InterruptedException, ExecutionException {
        if (!this.active) {
            throw new IllegalStateException("Executor is shut down");
        }
        FutureCompletedSpy futureCompletedSpy = new FutureCompletedSpy();
        LinkedList futureList = new LinkedList();
        for (PriorityCallable<T1, P> task : tasks) {
            FutureWrapper futureWrapper = new FutureWrapper(task.getPriority(), this.getNextTaskIndex(), task, futureCompletedSpy);
            if (!this.queue.offer(futureWrapper)) {
                throw new RejectedExecutionException("Queue is full");
            }
            futureList.add(futureWrapper);
        }
        T1 result = null;
        ExecutionException ee = null;
        try {
            result = (T1)futureCompletedSpy.get();
        }
        catch (ExecutionException e) {
            ee = e;
        }
        for (Future future : futureList) {
            future.cancel(false);
        }
        if (ee != null) {
            throw ee;
        }
        return result;
    }

    @Override
    public <T1> T1 invokeAny(Collection<? extends PriorityCallable<T1, P>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.active) {
            throw new IllegalStateException("Executor is shut down");
        }
        FutureCompletedSpy futureCompletedSpy = new FutureCompletedSpy();
        LinkedList futureList = new LinkedList();
        for (PriorityCallable<T1, P> task : tasks) {
            FutureWrapper futureWrapper = new FutureWrapper(task.getPriority(), this.getNextTaskIndex(), task, futureCompletedSpy);
            if (!this.queue.offer(futureWrapper)) {
                throw new RejectedExecutionException("Queue is full");
            }
            futureList.add(futureWrapper);
        }
        T1 result = null;
        ExecutionException ee = null;
        try {
            result = (T1)futureCompletedSpy.get(timeout, unit);
        }
        catch (ExecutionException e) {
            ee = e;
        }
        for (Future future : futureList) {
            future.cancel(false);
        }
        if (ee != null) {
            throw ee;
        }
        return result;
    }

    @Override
    public void execute(PriorityRunnable<P> command) {
        if (!this.active) {
            throw new IllegalStateException("Executor is shut down");
        }
        if (!this.queue.offer(new TaskWrapper<P>(command.getPriority(), this.getNextTaskIndex(), command))) {
            throw new RejectedExecutionException("Queue is full");
        }
    }
}

