/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.lang.ref.WeakReference;
import javafx.scene.control.TableColumnBase;

public abstract class TablePositionBase<TC extends TableColumnBase> {
    private final int row;
    private final WeakReference<TC> tableColumnRef;

    protected TablePositionBase(int row, TC tableColumn) {
        this.row = row;
        this.tableColumnRef = new WeakReference<TC>(tableColumn);
    }

    public int getRow() {
        return this.row;
    }

    public abstract int getColumn();

    public TC getTableColumn() {
        return (TC)((TableColumnBase)this.tableColumnRef.get());
    }

    public boolean equals(Object obj) {
        TC otherTableColumn;
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TablePositionBase other = (TablePositionBase)obj;
        if (this.row != other.row) {
            return false;
        }
        TC tableColumn = this.getTableColumn();
        return tableColumn == (otherTableColumn = other.getTableColumn()) || tableColumn != null && tableColumn.equals(otherTableColumn);
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + this.row;
        TC tableColumn = this.getTableColumn();
        hash = 79 * hash + (tableColumn != null ? tableColumn.hashCode() : 0);
        return hash;
    }
}

