/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.common.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import si.nevensrok.common.objects.ObjectToString;
import si.nevensrok.common.utils.CollectionUtil;
import si.nevensrok.jtekma.common.competitors.Competitor;

public class DuoTable
implements Serializable {
    private static final long serialVersionUID = -1799073353592862626L;
    private List<Row> rows;
    private boolean finished = false;

    public List<Row> getRows() {
        return this.rows;
    }

    public void setRows(List<Row> rows) {
        this.rows = rows;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public void addCompetitor(Competitor competitor) {
        if (competitor == null) {
            return;
        }
        Row row = new Row();
        row.setCompetitor(competitor);
        if (this.rows == null) {
            this.rows = new LinkedList<Row>();
        }
        this.rows.add(row);
    }

    public void addCompetitors(Collection<Competitor> competitors) {
        if (CollectionUtil.isEmpty(competitors)) {
            return;
        }
        for (Competitor competitor : competitors) {
            this.addCompetitor(competitor);
        }
    }

    public Competitor getCompetitorAtPosition(int n) {
        if (this.rows == null) {
            return null;
        }
        if (n > this.rows.size()) {
            return null;
        }
        ArrayList<Row> list = new ArrayList<Row>(this.rows);
        Collections.sort(list, new Comparator<Row>(){

            @Override
            public int compare(Row o1, Row o2) {
                int placing1 = o1.getPlacing() == null ? Integer.MAX_VALUE : o1.getPlacing();
                int placing2 = o2.getPlacing() == null ? Integer.MAX_VALUE : o2.getPlacing();
                return Integer.compare(placing1, placing2);
            }
        });
        return ((Row)list.get(n - 1)).getCompetitor();
    }

    public String toString() {
        return new ObjectToString(DuoTable.class).addProperty("rows", this.rows).addProperty("finished", this.finished).generateString();
    }

    public static class Row
    implements Serializable {
        private static final long serialVersionUID = -7641984004030531912L;
        private Competitor competitor;
        private float round1Points = 0.0f;
        private float round1VarietyScorePoints = 0.0f;
        private float round2Points = 0.0f;
        private float round2VarietyScorePoints = 0.0f;
        private float round3Points = 0.0f;
        private float round3VarietyScorePoints = 0.0f;
        private float totalPoints = 0.0f;
        private float totalVarietyScorePoints = 0.0f;
        private int finished = 0;
        private Integer placing = null;

        public Competitor getCompetitor() {
            return this.competitor;
        }

        public void setCompetitor(Competitor competitor) {
            this.competitor = competitor;
        }

        public float getRound1Points() {
            return this.round1Points;
        }

        public void setRound1Points(float round1Points) {
            this.round1Points = round1Points;
        }

        public float getRound1VarietyScorePoints() {
            return this.round1VarietyScorePoints;
        }

        public void setRound1VarietyScorePoints(float round1VarietyScorePoints) {
            this.round1VarietyScorePoints = round1VarietyScorePoints;
        }

        public float getRound2Points() {
            return this.round2Points;
        }

        public void setRound2Points(float round2Points) {
            this.round2Points = round2Points;
        }

        public float getRound2VarietyScorePoints() {
            return this.round2VarietyScorePoints;
        }

        public void setRound2VarietyScorePoints(float round2VarietyScorePoints) {
            this.round2VarietyScorePoints = round2VarietyScorePoints;
        }

        public float getRound3Points() {
            return this.round3Points;
        }

        public void setRound3Points(float round3Points) {
            this.round3Points = round3Points;
        }

        public float getRound3VarietyScorePoints() {
            return this.round3VarietyScorePoints;
        }

        public void setRound3VarietyScorePoints(float round3VarietyScorePoints) {
            this.round3VarietyScorePoints = round3VarietyScorePoints;
        }

        public float getTotalPoints() {
            return this.totalPoints;
        }

        public void setTotalPoints(float totalPoints) {
            this.totalPoints = totalPoints;
        }

        public float getTotalVarietyScorePoints() {
            return this.totalVarietyScorePoints;
        }

        public void setTotalVarietyScorePoints(float totalVarietyScorePoints) {
            this.totalVarietyScorePoints = totalVarietyScorePoints;
        }

        public int getFinished() {
            return this.finished;
        }

        public void setFinished(int finished) {
            this.finished = finished;
        }

        public Integer getPlacing() {
            return this.placing;
        }

        public void setPlacing(Integer placing) {
            this.placing = placing;
        }

        public String toString() {
            return new ObjectToString(Row.class).addProperty("competitor", (Object)this.competitor).addProperty("round1Points", this.round1Points).addProperty("round1VarietyScorePoints", this.round1VarietyScorePoints).addProperty("round2Points", this.round2Points).addProperty("round2VarietyScorePoints", this.round2VarietyScorePoints).addProperty("round3Points", this.round3Points).addProperty("round3VarietyScorePoints", this.round3VarietyScorePoints).addProperty("totalPoints", this.totalPoints).addProperty("totalVarietyScorePoints", this.totalVarietyScorePoints).addProperty("finished", this.finished).addProperty("placing", (Object)this.placing).generateString();
        }
    }
}

