/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.RectangularShape;
import com.sun.javafx.geom.RoundRectIterator;
import com.sun.javafx.geom.transform.BaseTransform;

public class RoundRectangle2D
extends RectangularShape {
    public float x;
    public float y;
    public float width;
    public float height;
    public float arcWidth;
    public float arcHeight;

    public RoundRectangle2D() {
    }

    public RoundRectangle2D(float x, float y, float w, float h, float arcw, float arch) {
        this.setRoundRect(x, y, w, h, arcw, arch);
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public boolean isEmpty() {
        return this.width <= 0.0f || this.height <= 0.0f;
    }

    public void setRoundRect(float x, float y, float w, float h, float arcw, float arch) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        this.arcWidth = arcw;
        this.arcHeight = arch;
    }

    @Override
    public RectBounds getBounds() {
        return new RectBounds(this.x, this.y, this.x + this.width, this.y + this.height);
    }

    public void setRoundRect(RoundRectangle2D rr) {
        this.setRoundRect(rr.x, rr.y, rr.width, rr.height, rr.arcWidth, rr.arcHeight);
    }

    @Override
    public void setFrame(float x, float y, float w, float h) {
        this.setRoundRect(x, y, w, h, this.arcWidth, this.arcHeight);
    }

    @Override
    public boolean contains(float x, float y) {
        float f;
        float f2;
        if (this.isEmpty()) {
            return false;
        }
        float rrx0 = this.x;
        float rry0 = this.y;
        float rrx1 = rrx0 + this.width;
        float rry1 = rry0 + this.height;
        if (x < rrx0 || y < rry0 || x >= rrx1 || y >= rry1) {
            return false;
        }
        float aw = Math.min(this.width, Math.abs(this.arcWidth)) / 2.0f;
        float ah = Math.min(this.height, Math.abs(this.arcHeight)) / 2.0f;
        rrx0 += aw;
        if (x >= f2) {
            float f3;
            rrx0 = rrx1 - aw;
            if (x < f3) {
                return true;
            }
        }
        rry0 += ah;
        if (y >= f) {
            float f4;
            rry0 = rry1 - ah;
            if (y < f4) {
                return true;
            }
        }
        return (double)((x = (x - rrx0) / aw) * x + (y = (y - rry0) / ah) * y) <= 1.0;
    }

    private int classify(float coord, float left, float right, float arcsize) {
        if (coord < left) {
            return 0;
        }
        if (coord < left + arcsize) {
            return 1;
        }
        if (coord < right - arcsize) {
            return 2;
        }
        if (coord < right) {
            return 3;
        }
        return 4;
    }

    @Override
    public boolean intersects(float x, float y, float w, float h) {
        if (this.isEmpty() || w <= 0.0f || h <= 0.0f) {
            return false;
        }
        float rrx0 = this.x;
        float rry0 = this.y;
        float rrx1 = rrx0 + this.width;
        float rry1 = rry0 + this.height;
        if (x + w <= rrx0 || x >= rrx1 || y + h <= rry0 || y >= rry1) {
            return false;
        }
        float aw = Math.min(this.width, Math.abs(this.arcWidth)) / 2.0f;
        float ah = Math.min(this.height, Math.abs(this.arcHeight)) / 2.0f;
        int x0class = this.classify(x, rrx0, rrx1, aw);
        int x1class = this.classify(x + w, rrx0, rrx1, aw);
        int y0class = this.classify(y, rry0, rry1, ah);
        int y1class = this.classify(y + h, rry0, rry1, ah);
        if (x0class == 2 || x1class == 2 || y0class == 2 || y1class == 2) {
            return true;
        }
        if (x0class < 2 && x1class > 2 || y0class < 2 && y1class > 2) {
            return true;
        }
        x = x1class == 1 ? (x = x + w - (rrx0 + aw)) : (x = x - (rrx1 - aw));
        y = y1class == 1 ? (y = y + h - (rry0 + ah)) : (y = y - (rry1 - ah));
        return (x /= aw) * x + (y /= ah) * y <= 1.0f;
    }

    @Override
    public boolean contains(float x, float y, float w, float h) {
        if (this.isEmpty() || w <= 0.0f || h <= 0.0f) {
            return false;
        }
        return this.contains(x, y) && this.contains(x + w, y) && this.contains(x, y + h) && this.contains(x + w, y + h);
    }

    @Override
    public PathIterator getPathIterator(BaseTransform tx) {
        return new RoundRectIterator(this, tx);
    }

    @Override
    public RoundRectangle2D copy() {
        return new RoundRectangle2D(this.x, this.y, this.width, this.height, this.arcWidth, this.arcHeight);
    }

    public int hashCode() {
        int bits = Float.floatToIntBits(this.x);
        bits += Float.floatToIntBits(this.y) * 37;
        bits += Float.floatToIntBits(this.width) * 43;
        bits += Float.floatToIntBits(this.height) * 47;
        bits += Float.floatToIntBits(this.arcWidth) * 53;
        return bits += Float.floatToIntBits(this.arcHeight) * 59;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RoundRectangle2D) {
            RoundRectangle2D rr2d = (RoundRectangle2D)obj;
            return this.x == rr2d.x && this.y == rr2d.y && this.width == rr2d.width && this.height == rr2d.height && this.arcWidth == rr2d.arcWidth && this.arcHeight == rr2d.arcHeight;
        }
        return false;
    }
}

