/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.CompositeFontResource;
import com.sun.javafx.font.CompositeStrikeDisposer;
import com.sun.javafx.font.DisposerRecord;
import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.FontStrikeDesc;
import com.sun.javafx.font.Glyph;
import com.sun.javafx.font.Metrics;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.font.PrismFontFile;
import com.sun.javafx.font.PrismMetrics;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.text.GlyphList;

public class CompositeStrike
implements FontStrike {
    private CompositeFontResource fontResource;
    private float size;
    private int aaMode;
    BaseTransform transform;
    private FontStrike slot0Strike;
    private FontStrike[] strikeSlots;
    private FontStrikeDesc desc;
    DisposerRecord disposer;
    private PrismMetrics metrics;

    @Override
    public void clearDesc() {
        this.fontResource.getStrikeMap().remove(this.desc);
        if (this.slot0Strike != null) {
            this.slot0Strike.clearDesc();
        }
        if (this.strikeSlots != null) {
            for (int i = 1; i < this.strikeSlots.length; ++i) {
                if (this.strikeSlots[i] == null) continue;
                this.strikeSlots[i].clearDesc();
            }
        }
    }

    CompositeStrike(CompositeFontResource fontResource, float size, BaseTransform graphicsTransform, int aaMode, FontStrikeDesc desc) {
        this.fontResource = fontResource;
        this.size = size;
        this.transform = graphicsTransform.isTranslateOrIdentity() ? BaseTransform.IDENTITY_TRANSFORM : graphicsTransform.copy();
        this.desc = desc;
        this.aaMode = aaMode;
        this.disposer = new CompositeStrikeDisposer(fontResource, desc);
    }

    @Override
    public int getAAMode() {
        PrismFontFactory factory = PrismFontFactory.getFontFactory();
        if (factory.isLCDTextSupported()) {
            return this.aaMode;
        }
        return 0;
    }

    @Override
    public BaseTransform getTransform() {
        return this.transform;
    }

    public FontStrike getStrikeSlot(int slot) {
        if (slot == 0) {
            if (this.slot0Strike == null) {
                FontResource slot0Resource = this.fontResource.getSlotResource(0);
                this.slot0Strike = slot0Resource.getStrike(this.size, this.transform, this.getAAMode());
            }
            return this.slot0Strike;
        }
        if (this.strikeSlots == null) {
            this.strikeSlots = new FontStrike[this.fontResource.getNumSlots()];
        }
        if (slot >= this.strikeSlots.length) {
            FontStrike[] tmp = new FontStrike[this.fontResource.getNumSlots()];
            System.arraycopy(this.strikeSlots, 0, tmp, 0, this.strikeSlots.length);
            this.strikeSlots = tmp;
        }
        if (this.strikeSlots[slot] == null) {
            FontResource slotResource = this.fontResource.getSlotResource(slot);
            this.strikeSlots[slot] = slotResource.getStrike(this.size, this.transform, this.getAAMode());
        }
        return this.strikeSlots[slot];
    }

    @Override
    public FontResource getFontResource() {
        return this.fontResource;
    }

    public int getStrikeSlotForGlyph(int glyphCode) {
        return glyphCode >>> 24;
    }

    @Override
    public float getSize() {
        return this.size;
    }

    @Override
    public boolean drawAsShapes() {
        return this.getStrikeSlot(0).drawAsShapes();
    }

    @Override
    public Metrics getMetrics() {
        if (this.metrics == null) {
            PrismFontFile fr = (PrismFontFile)this.fontResource.getSlotResource(0);
            this.metrics = fr.getFontMetrics(this.size);
        }
        return this.metrics;
    }

    @Override
    public Glyph getGlyph(char symbol) {
        int glyphCode = this.fontResource.getGlyphMapper().charToGlyph(symbol);
        return this.getGlyph(glyphCode);
    }

    @Override
    public Glyph getGlyph(int glyphCode) {
        int slot = glyphCode >>> 24;
        int slotglyphCode = glyphCode & 0xFFFFFF;
        return this.getStrikeSlot(slot).getGlyph(slotglyphCode);
    }

    @Override
    public float getCharAdvance(char ch) {
        int glyphCode = this.fontResource.getGlyphMapper().charToGlyph((int)ch);
        return this.fontResource.getAdvance(glyphCode, this.size);
    }

    @Override
    public int getQuantizedPosition(Point2D point) {
        return this.getStrikeSlot(0).getQuantizedPosition(point);
    }

    @Override
    public Shape getOutline(GlyphList gl, BaseTransform transform) {
        Path2D result = new Path2D();
        this.getOutline(gl, transform, result);
        return result;
    }

    void getOutline(GlyphList gl, BaseTransform transform, Path2D p) {
        p.reset();
        if (gl == null) {
            return;
        }
        if (transform == null) {
            transform = BaseTransform.IDENTITY_TRANSFORM;
        }
        Affine2D t = new Affine2D();
        for (int i = 0; i < gl.getGlyphCount(); ++i) {
            Glyph glyph;
            Shape gp;
            int glyphCode = gl.getGlyphCode(i);
            if (glyphCode == 65535 || (gp = (glyph = this.getGlyph(glyphCode)).getShape()) == null) continue;
            t.setTransform(transform);
            t.translate(gl.getPosX(i), gl.getPosY(i));
            p.append(gp.getPathIterator(t), false);
        }
    }
}

