/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.ssl.BcTrustManager;
import si.nevensrok.common.ssl.BcTrustManagerImpl;
import si.nevensrok.common.ssl.CustomSSLSocketFactory;
import si.nevensrok.common.ssl.CustomSslContextGenerator;
import si.nevensrok.common.ssl.KeystoreBcCertificateRepository;
import si.nevensrok.common.ssl.KeystoreCertificateRepository;
import si.nevensrok.common.ssl.SslContextGenerator;
import si.nevensrok.common.ssl.SystemRevokedCertificateChecker;

public final class SystemTrustStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemTrustStore.class);
    public static final String KEYSTORE_PASSWORD = "changeit";
    private static KeyStore trustStore;

    private SystemTrustStore() {
    }

    public static KeyStore getSystemTrustStore() {
        return trustStore;
    }

    public static SslContextGenerator getSystemSslContextGenerator() {
        CustomSslContextGenerator sslContextGenerator = new CustomSslContextGenerator();
        sslContextGenerator.setTrustStoreRepository(new KeystoreCertificateRepository(SystemTrustStore.getSystemTrustStore()));
        sslContextGenerator.setRevokedCertificateChecker(SystemRevokedCertificateChecker.getSystemRevokedCertificateChecker());
        try {
            sslContextGenerator.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing ssl context generator", e);
        }
        return sslContextGenerator;
    }

    public static SSLContext getSystemSslContext() {
        return SystemTrustStore.getSystemSslContextGenerator().generateSSLContext();
    }

    public static SSLSocketFactory getSystemSSLSocketFactory() {
        return new CustomSSLSocketFactory(SystemTrustStore.getSystemSslContext());
    }

    public static BcTrustManager getSystemBcTrustManager() {
        BcTrustManagerImpl bcTrustManager = new BcTrustManagerImpl(new KeystoreBcCertificateRepository(SystemTrustStore.getSystemTrustStore(), KEYSTORE_PASSWORD));
        bcTrustManager.setRevokedCertificateChecker(SystemRevokedCertificateChecker.getSystemRevokedCertificateChecker());
        return bcTrustManager;
    }

    static {
        InputStream inputStream = null;
        try {
            File file = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts");
            inputStream = new FileInputStream(file);
            trustStore = KeyStore.getInstance("JKS");
            trustStore.load(inputStream, KEYSTORE_PASSWORD.toCharArray());
        }
        catch (Exception e) {
            LOGGER.error("Error loading system truststore", (Throwable)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }
}

