/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.ssl.BcCertificateRepository;
import si.nevensrok.common.x509cert.CertificateUtil;
import si.nevensrok.common.x509cert.KeyUtil;

public class KeystoreBcCertificateRepository
implements BcCertificateRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeystoreBcCertificateRepository.class);
    private KeyStore keyStore;
    private char[] password;
    private BcTlsCrypto bcTlsCrypto;
    private Map<String, Certificate> certificates = new LinkedHashMap<String, Certificate>();
    private Map<String, Certificate[]> certificateChains = new LinkedHashMap<String, Certificate[]>();
    private Map<String, BcTlsCertificate> bcTlsCertificates = new LinkedHashMap<String, BcTlsCertificate>();
    private Map<String, BcTlsCertificate[]> bcTlsCertificateChains = new LinkedHashMap<String, BcTlsCertificate[]>();
    private Map<String, AsymmetricKeyParameter> privateKeys = new LinkedHashMap<String, AsymmetricKeyParameter>();

    public KeystoreBcCertificateRepository() {
    }

    public KeystoreBcCertificateRepository(KeyStore keyStore) {
        this.keyStore = keyStore;
        this.password = "changeit".toCharArray();
        this.loadData();
    }

    public KeystoreBcCertificateRepository(KeyStore keyStore, String password) {
        this.keyStore = keyStore;
        if (password != null) {
            this.password = password.toCharArray();
        }
        this.loadData();
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
        this.loadData();
    }

    public void setPassword(String password) {
        this.password = (char[])(password != null ? password.toCharArray() : null);
        this.loadData();
    }

    private void loadData() {
        this.bcTlsCrypto = new BcTlsCrypto(new SecureRandom());
        this.certificates.clear();
        this.privateKeys.clear();
        if (this.keyStore != null && this.password != null) {
            try {
                Enumeration<String> aliasEnumeration = this.keyStore.aliases();
                while (aliasEnumeration.hasMoreElements()) {
                    String alias = aliasEnumeration.nextElement();
                    try {
                        if (this.keyStore.isKeyEntry(alias)) {
                            LinkedList<Certificate> chain = new LinkedList<Certificate>();
                            LinkedList<BcTlsCertificate> bcTlsChain = new LinkedList<BcTlsCertificate>();
                            for (java.security.cert.Certificate certificate : this.keyStore.getCertificateChain(alias)) {
                                Certificate cert = this.convertToCertificate(certificate);
                                chain.add(cert);
                                BcTlsCertificate bcTlsCert = this.convertToBcTlsCertificate(certificate);
                                bcTlsChain.add(bcTlsCert);
                            }
                            this.certificateChains.put(alias, chain.toArray(new Certificate[chain.size()]));
                            this.certificates.put(alias, (Certificate)chain.get(0));
                            this.bcTlsCertificateChains.put(alias, bcTlsChain.toArray(new BcTlsCertificate[bcTlsChain.size()]));
                            this.bcTlsCertificates.put(alias, (BcTlsCertificate)bcTlsChain.get(0));
                            PrivateKey privateKey = (PrivateKey)this.keyStore.getKey(alias, this.password);
                            AsymmetricKeyParameter asymmetricKeyParameter = this.convertPrivateKey(privateKey);
                            this.privateKeys.put(alias, asymmetricKeyParameter);
                            continue;
                        }
                        java.security.cert.Certificate certificate = this.keyStore.getCertificate(alias);
                        Certificate cert = this.convertToCertificate(certificate);
                        this.certificates.put(alias, cert);
                        this.certificateChains.put(alias, new Certificate[]{cert});
                        BcTlsCertificate bcTlsCertificate = this.convertToBcTlsCertificate(certificate);
                        this.bcTlsCertificates.put(alias, bcTlsCertificate);
                        this.bcTlsCertificateChains.put(alias, new BcTlsCertificate[]{bcTlsCertificate});
                    }
                    catch (Exception e) {
                        LOGGER.error("Error load alias " + alias, (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error loading keystore data", (Throwable)e);
            }
        }
    }

    @Override
    public boolean isCertificatePresent(String alias) {
        return this.certificates.containsKey(alias);
    }

    @Override
    public Certificate getCertificate(String alias) {
        return this.certificates.get(alias);
    }

    @Override
    public Certificate[] getCertificateChain(String alias) {
        return this.certificateChains.get(alias);
    }

    @Override
    public BcTlsCertificate getBcTlsCertificate(String alias) {
        return this.bcTlsCertificates.get(alias);
    }

    @Override
    public BcTlsCertificate[] getBcTlsCertificateChain(String alias) {
        return this.bcTlsCertificateChains.get(alias);
    }

    @Override
    public List<String> getAliases() {
        return new LinkedList<String>(this.certificates.keySet());
    }

    @Override
    public boolean isPrivateKeyPresent(String alias) {
        return this.privateKeys.containsKey(alias);
    }

    @Override
    public AsymmetricKeyParameter getPrivateKey(String alias) {
        return this.privateKeys.get(alias);
    }

    @Override
    public List<String> getAliasesWithPrivateKey() {
        return new LinkedList<String>(this.privateKeys.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PemObject readPemObject(InputStream inputStream) throws IOException {
        PemReader pemReader = null;
        try {
            pemReader = new PemReader((Reader)new InputStreamReader(inputStream));
            PemObject pemObject = pemReader.readPemObject();
            return pemObject;
        }
        finally {
            try {
                pemReader.close();
            }
            catch (Exception exception) {}
        }
    }

    private Certificate convertToCertificate(java.security.cert.Certificate certificate) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        CertificateUtil.saveCertificateAsBase64(certificate, buffer);
        PemObject pemObject = this.readPemObject(new ByteArrayInputStream(buffer.toByteArray()));
        if (pemObject.getType().endsWith("CERTIFICATE")) {
            Certificate c = Certificate.getInstance((Object)pemObject.getContent());
            return c;
        }
        throw new IOException("Invalid object type: " + pemObject.getType());
    }

    private BcTlsCertificate convertToBcTlsCertificate(java.security.cert.Certificate certificate) throws IOException, CertificateEncodingException {
        BcTlsCertificate bcTlsCertificate = new BcTlsCertificate(this.bcTlsCrypto, certificate.getEncoded());
        return bcTlsCertificate;
    }

    private AsymmetricKeyParameter convertPrivateKey(PrivateKey privateKey) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        KeyUtil.savePrivateKey(privateKey, buffer);
        PemObject pemObject = this.readPemObject(new ByteArrayInputStream(buffer.toByteArray()));
        if (pemObject.getType().endsWith("RSA PRIVATE KEY")) {
            RSAPrivateCrtKey rsaPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
            return new RSAPrivateCrtKeyParameters(rsaPrivateCrtKey.getModulus(), rsaPrivateCrtKey.getPublicExponent(), rsaPrivateCrtKey.getPrivateExponent(), rsaPrivateCrtKey.getPrimeP(), rsaPrivateCrtKey.getPrimeQ(), rsaPrivateCrtKey.getPrimeExponentP(), rsaPrivateCrtKey.getPrimeExponentQ(), rsaPrivateCrtKey.getCrtCoefficient());
        }
        if (pemObject.getType().endsWith("PRIVATE KEY")) {
            return PrivateKeyFactory.createKey((byte[])pemObject.getContent());
        }
        throw new IOException("Invalid object type: " + pemObject.getType());
    }
}

