/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.fxml.expression;

import com.sun.javafx.fxml.expression.Expression;
import com.sun.javafx.fxml.expression.KeyPath;
import java.util.List;
import java.util.function.BiFunction;

public final class BinaryExpression<U, T>
extends Expression<T> {
    private final BiFunction<U, U, T> evaluator;
    private final Expression<U> left;
    private final Expression<U> right;

    public BinaryExpression(Expression<U> left, Expression<U> right, BiFunction<U, U, T> evaluator) {
        if (left == null) {
            throw new NullPointerException();
        }
        if (right == null) {
            throw new NullPointerException();
        }
        this.left = left;
        this.right = right;
        this.evaluator = evaluator;
    }

    @Override
    public T evaluate(Object namespace) {
        return this.evaluator.apply(this.left.evaluate(namespace), this.right.evaluate(namespace));
    }

    @Override
    public void update(Object namespace, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDefined(Object namespace) {
        return this.left.isDefined(namespace) && this.right.isDefined(namespace);
    }

    @Override
    public boolean isLValue() {
        return false;
    }

    @Override
    protected void getArguments(List<KeyPath> arguments) {
        this.left.getArguments(arguments);
        this.right.getArguments(arguments);
    }
}

