/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.gui.TextSource;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class ChallengePanel
extends JPanel {
    private static final String AVAILABLE = "\u2713";
    private static final String NOT_AVAILABLE = "\u274c";
    private JLabel challengeLabel = new JLabel("Challenge");
    private JLabel availableLabel = new JLabel("\u2713");
    private CompetitorType competitorType;
    private MatchData matchData;
    private TextSource textSource;
    private TablaManager tablaManager;

    public ChallengePanel(final CompetitorType competitorType) {
        this.competitorType = competitorType;
        this.setLayout(null);
        this.add(this.challengeLabel);
        this.add(this.availableLabel);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    if (competitorType == CompetitorType.COMPETITOR1) {
                        if (ChallengePanel.this.matchData.isChallengeAvailable1() && ChallengePanel.this.matchData.getChallengesLost1() == 0) {
                            ChallengePanel.this.tablaManager.showChallenge(1);
                        }
                    } else if (competitorType == CompetitorType.COMPETITOR2 && ChallengePanel.this.matchData.isChallengeAvailable2() && ChallengePanel.this.matchData.getChallengesLost2() == 0) {
                        ChallengePanel.this.tablaManager.showChallenge(2);
                    }
                }
            }
        });
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void setTextSource(TextSource textSource) {
        this.textSource = textSource;
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.tablaManager = tablaManager;
    }

    public void redrawElements() {
        int width = this.getWidth();
        int height = this.getHeight();
        int challengeLabelWidth = (int)Math.floor((float)width * 0.8f);
        this.challengeLabel.setLocation(0, 0);
        this.challengeLabel.setSize(challengeLabelWidth, height);
        this.challengeLabel.setText(this.textSource.getLanguageText("text.challenge"));
        FontSizeUtil.refitFontSize(Constants.FONT, this.challengeLabel);
        this.availableLabel.setLocation(challengeLabelWidth, 0);
        this.availableLabel.setSize(width - challengeLabelWidth, height);
        if (this.competitorType == CompetitorType.COMPETITOR1) {
            if (this.matchData.isChallengeAvailable1() && this.matchData.getChallengesLost1() == 0) {
                this.availableLabel.setText(this.textSource.getLanguageText(AVAILABLE));
            } else {
                this.availableLabel.setText(this.textSource.getLanguageText(NOT_AVAILABLE));
            }
        } else if (this.competitorType == CompetitorType.COMPETITOR2) {
            if (this.matchData.isChallengeAvailable2() && this.matchData.getChallengesLost2() == 0) {
                this.availableLabel.setText(this.textSource.getLanguageText(AVAILABLE));
            } else {
                this.availableLabel.setText(this.textSource.getLanguageText(NOT_AVAILABLE));
            }
        }
        FontSizeUtil.refitFontSize(Constants.FONT, this.availableLabel);
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.challengeLabel != null) {
            this.challengeLabel.setBackground(bg);
        }
        if (this.availableLabel != null) {
            this.availableLabel.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.challengeLabel != null) {
            this.challengeLabel.setForeground(fg);
        }
        if (this.availableLabel != null) {
            this.availableLabel.setForeground(fg);
        }
    }
}

