-- create table
CREATE TABLE Requests
(
	RequestId bigint NOT NULL AUTO_INCREMENT,
	MethodId varchar(4096) NOT NULL,
	BeanName varchar(4096),
	RequestDate timestamp NOT NULL,
	ThreadName varchar(4096) NOT NULL,
	Duration int NOT NULL,
	WithoutError tinyint(1) NOT NULL,
	ErrorData text,
	MachineIp4 varchar(15),
	MachineIp6 varchar(45),
	MachineHostname varchar(1024),
	MachineName varchar(100),
	ProcessName varchar(1024),
	PRIMARY KEY (RequestId)
) ENGINE = InnoDB DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


CREATE TABLE RequestDatas
(
	RequestId bigint NOT NULL,
	ParameterName varchar(4096) NOT NULL,
	ParameterValue text,
	ParameterClass varchar(4096)
) ENGINE = InnoDB DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


CREATE TABLE ResponseDatas
(
	RequestId bigint NOT NULL,
	ParameterName varchar(4096) NOT NULL,
	ParameterValue text,
	ParameterClass varchar(4096)
) ENGINE = InnoDB DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


ALTER TABLE ResponseDatas
	ADD FOREIGN KEY (RequestId)
	REFERENCES Requests (RequestId)
	ON UPDATE RESTRICT
	ON DELETE RESTRICT
;


ALTER TABLE RequestDatas
	ADD FOREIGN KEY (RequestId)
	REFERENCES Requests (RequestId)
	ON UPDATE RESTRICT
	ON DELETE RESTRICT
;

--search index
CREATE INDEX SearchIndex1 ON Requests (RequestDate,MethodId,BeanName,WithoutError);

