SET SESSION FOREIGN_KEY_CHECKS=0;

/* Drop Tables */

DROP TABLE testlog;




/* Create Tables */

CREATE TABLE testlog
(
	Id bigint NOT NULL AUTO_INCREMENT,
	EventDate timestamp NOT NULL,
	ThreadName varchar(1024) NOT NULL,
	Category varchar(1024) NOT NULL,
	LogLevel varchar(10) NOT NULL,
	Message text NOT NULL,
	Throwable text,
	LocationClassName varchar(1024) NOT NULL,
	LocationMethodName varchar(256) NOT NULL,
	LocationLineNumber varchar(10) NOT NULL,
	MachineIp4 varchar(15),
	MachineIp6 varchar(45),
	MachineHostname varchar(1024),
	MachineName varchar(100),
	ProcessName varchar(1024),
	PRIMARY KEY (Id)
) ENGINE = InnoDB DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


/* Create indexes */
CREATE INDEX LogSearchIndex1 ON testlog (EventDate ASC, LogLevel ASC);

