/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.RectangularShape;
import com.sun.javafx.geom.RoundRectangle2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.prism.EffectUtil;
import com.sun.javafx.sg.prism.NGShape;
import com.sun.prism.BasicStroke;
import com.sun.prism.Graphics;
import com.sun.prism.RectShadowGraphics;
import com.sun.prism.paint.Color;
import com.sun.prism.shape.ShapeRep;
import com.sun.scenario.effect.Effect;

public class NGRectangle
extends NGShape {
    private RoundRectangle2D rrect = new RoundRectangle2D();
    static final float HALF_MINUS_HALF_SQRT_HALF = 0.14700001f;
    private static final double SQRT_2 = Math.sqrt(2.0);

    public void updateRectangle(float x, float y, float width, float height, float arcWidth, float arcHeight) {
        this.rrect.x = x;
        this.rrect.y = y;
        this.rrect.width = width;
        this.rrect.height = height;
        this.rrect.arcWidth = arcWidth;
        this.rrect.arcHeight = arcHeight;
        this.geometryChanged();
    }

    @Override
    protected boolean supportsOpaqueRegions() {
        return true;
    }

    @Override
    protected boolean hasOpaqueRegion() {
        return super.hasOpaqueRegion() && this.rrect.width > 1.0f && this.rrect.height > 1.0f;
    }

    @Override
    protected RectBounds computeOpaqueRegion(RectBounds opaqueRegion) {
        float x = this.rrect.x;
        float y = this.rrect.y;
        float w = this.rrect.width;
        float h = this.rrect.height;
        float aw = this.rrect.arcWidth;
        float ah = this.rrect.arcHeight;
        if (aw <= 0.0f || ah <= 0.0f) {
            return (RectBounds)opaqueRegion.deriveWithNewBounds(x, y, 0.0f, x + w, y + h, 0.0f);
        }
        float arcInsetWidth = Math.min(w, aw) * 0.14700001f;
        float arcInsetHeight = Math.min(h, ah) * 0.14700001f;
        return (RectBounds)opaqueRegion.deriveWithNewBounds(x + arcInsetWidth, y + arcInsetHeight, 0.0f, x + w - arcInsetWidth, y + h - arcInsetHeight, 0.0f);
    }

    boolean isRounded() {
        return this.rrect.arcWidth > 0.0f && this.rrect.arcHeight > 0.0f;
    }

    @Override
    protected void renderEffect(Graphics g) {
        if (!(g instanceof RectShadowGraphics) || !this.renderEffectDirectly(g)) {
            super.renderEffect(g);
        }
    }

    private boolean renderEffectDirectly(Graphics g) {
        if (this.mode != NGShape.Mode.FILL || this.isRounded()) {
            return false;
        }
        float alpha = g.getExtraAlpha();
        if (!(this.fillPaint instanceof Color)) {
            return false;
        }
        Effect effect = this.getEffect();
        return EffectUtil.renderEffectForRectangularNode(this, g, effect, alpha *= ((Color)this.fillPaint).getAlpha(), true, this.rrect.x, this.rrect.y, this.rrect.width, this.rrect.height);
    }

    @Override
    public final Shape getShape() {
        return this.rrect;
    }

    @Override
    protected ShapeRep createShapeRep(Graphics g) {
        return g.getResourceFactory().createRoundRectRep();
    }

    private static boolean hasRightAngleMiterAndNoDashes(BasicStroke bs) {
        return bs.getLineJoin() == 0 && (double)bs.getMiterLimit() >= SQRT_2 && bs.getDashArray() == null;
    }

    static boolean rectContains(float x, float y, NGShape node, RectangularShape r) {
        double rw = r.getWidth();
        double rh = r.getHeight();
        if (rw < 0.0 || rh < 0.0) {
            return false;
        }
        NGShape.Mode mode = node.mode;
        if (mode == NGShape.Mode.EMPTY) {
            return false;
        }
        double rx = r.getX();
        double ry = r.getY();
        if (mode == NGShape.Mode.FILL) {
            return (double)x >= rx && (double)y >= ry && (double)x < rx + rw && (double)y < ry + rh;
        }
        float outerpad = -1.0f;
        float innerpad = -1.0f;
        boolean checkstroke = false;
        BasicStroke drawstroke = node.drawStroke;
        int type = drawstroke.getType();
        if (type == 1) {
            if (mode == NGShape.Mode.STROKE_FILL) {
                outerpad = 0.0f;
            } else if (drawstroke.getDashArray() == null) {
                outerpad = 0.0f;
                innerpad = drawstroke.getLineWidth();
            } else {
                checkstroke = true;
            }
        } else if (type == 2) {
            if (NGRectangle.hasRightAngleMiterAndNoDashes(drawstroke)) {
                outerpad = drawstroke.getLineWidth();
                if (mode == NGShape.Mode.STROKE) {
                    innerpad = 0.0f;
                }
            } else {
                if (mode == NGShape.Mode.STROKE_FILL) {
                    outerpad = 0.0f;
                }
                checkstroke = true;
            }
        } else if (type == 0) {
            if (NGRectangle.hasRightAngleMiterAndNoDashes(drawstroke)) {
                outerpad = drawstroke.getLineWidth() / 2.0f;
                if (mode == NGShape.Mode.STROKE) {
                    innerpad = outerpad;
                }
            } else {
                if (mode == NGShape.Mode.STROKE_FILL) {
                    outerpad = 0.0f;
                }
                checkstroke = true;
            }
        } else {
            if (mode == NGShape.Mode.STROKE_FILL) {
                outerpad = 0.0f;
            }
            checkstroke = true;
        }
        if (outerpad >= 0.0f && (double)x >= rx - (double)outerpad && (double)y >= ry - (double)outerpad && (double)x < rx + rw + (double)outerpad && (double)y < ry + rh + (double)outerpad) {
            return !(innerpad >= 0.0f) || !((double)innerpad < rw / 2.0) || !((double)innerpad < rh / 2.0) || !((double)x >= rx + (double)innerpad) || !((double)y >= ry + (double)innerpad) || !((double)x < rx + rw - (double)innerpad) || !((double)y < ry + rh - (double)innerpad);
        }
        if (checkstroke) {
            return node.getStrokeShape().contains(x, y);
        }
        return false;
    }

    @Override
    protected final boolean isRectClip(BaseTransform xform, boolean permitRoundedRectangle) {
        long t;
        if (this.mode != NGShape.Mode.FILL || this.getClipNode() != null || this.getEffect() != null && this.getEffect().reducesOpaquePixels() || this.getOpacity() < 1.0f || !permitRoundedRectangle && this.isRounded() || !this.fillPaint.isOpaque()) {
            return false;
        }
        BaseTransform nodeXform = this.getTransform();
        if (!nodeXform.isIdentity()) {
            if (!xform.isIdentity()) {
                TEMP_TRANSFORM.setTransform(xform);
                TEMP_TRANSFORM.concatenate(nodeXform);
                xform = TEMP_TRANSFORM;
            } else {
                xform = nodeXform;
            }
        }
        return ((t = (long)xform.getType()) & 0xFFFFFFFFFFFFFFF0L) == 0L;
    }
}

