/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.x509cert;

import java.security.KeyPair;
import si.nevensrok.common.x509cert.KeyType;

public class KeyPairGenerator {
    private KeyType keyType;
    private Integer keySize;

    public KeyPairGenerator withKeyType(KeyType keyType) {
        this.keyType = keyType;
        return this;
    }

    public KeyPairGenerator withKeySize(Integer keySize) {
        this.keySize = keySize;
        return this;
    }

    public KeyPair generate() {
        if (this.keyType == null) {
            throw new IllegalArgumentException("KeyType is not set");
        }
        if (this.keySize == null) {
            throw new IllegalArgumentException("KeySize is not set");
        }
        try {
            java.security.KeyPairGenerator rsaKeyGenerator = java.security.KeyPairGenerator.getInstance(this.keyType.toString());
            rsaKeyGenerator.initialize(this.keySize);
            KeyPair keyPair = rsaKeyGenerator.generateKeyPair();
            return keyPair;
        }
        catch (Exception e) {
            throw new RuntimeException("Error generating RSA key pair", e);
        }
    }
}

