/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import com.sun.javafx.collections.TrackableObservableList;
import com.sun.scenario.animation.AbstractMasterTimer;
import com.sun.scenario.animation.shared.TimelineClipCore;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.util.Duration;

public final class Timeline
extends Animation {
    final TimelineClipCore clipCore;
    private final ObservableList<KeyFrame> keyFrames = new TrackableObservableList<KeyFrame>(){

        @Override
        protected void onChanged(ListChangeListener.Change<KeyFrame> c) {
            while (c.next()) {
                String cuePoint;
                if (c.wasPermutated()) continue;
                for (KeyFrame keyFrame : c.getRemoved()) {
                    cuePoint = keyFrame.getName();
                    if (cuePoint == null) continue;
                    Timeline.this.getCuePoints().remove(cuePoint);
                }
                for (KeyFrame keyFrame : c.getAddedSubList()) {
                    cuePoint = keyFrame.getName();
                    if (cuePoint == null) continue;
                    Timeline.this.getCuePoints().put(cuePoint, keyFrame.getTime());
                }
                Duration duration = Timeline.this.clipCore.setKeyFrames(Timeline.this.getKeyFrames());
                Timeline.this.setCycleDuration(duration);
            }
        }
    };

    public final ObservableList<KeyFrame> getKeyFrames() {
        return this.keyFrames;
    }

    public Timeline(double targetFramerate, KeyFrame ... keyFrames) {
        super(targetFramerate);
        this.clipCore = new TimelineClipCore(this);
        this.getKeyFrames().setAll((KeyFrame[])keyFrames);
    }

    public Timeline(KeyFrame ... keyFrames) {
        this.clipCore = new TimelineClipCore(this);
        this.getKeyFrames().setAll((KeyFrame[])keyFrames);
    }

    public Timeline(double targetFramerate) {
        super(targetFramerate);
        this.clipCore = new TimelineClipCore(this);
    }

    public Timeline() {
        this.clipCore = new TimelineClipCore(this);
    }

    Timeline(AbstractMasterTimer timer) {
        super(timer);
        this.clipCore = new TimelineClipCore(this);
    }

    @Override
    void impl_playTo(long currentTicks, long cycleTicks) {
        this.clipCore.playTo(currentTicks);
    }

    @Override
    void impl_jumpTo(long currentTicks, long cycleTicks, boolean forceJump) {
        this.impl_sync(false);
        this.impl_setCurrentTicks(currentTicks);
        this.clipCore.jumpTo(currentTicks, forceJump);
    }

    @Override
    void impl_setCurrentRate(double currentRate) {
        super.impl_setCurrentRate(currentRate);
        this.clipCore.notifyCurrentRateChanged();
    }

    @Override
    void impl_start(boolean forceSync) {
        super.impl_start(forceSync);
        this.clipCore.start(forceSync);
    }

    @Override
    public void stop() {
        if (this.parent != null) {
            throw new IllegalStateException("Cannot stop when embedded in another animation");
        }
        if (this.getStatus() == Animation.Status.RUNNING) {
            this.clipCore.abort();
        }
        super.stop();
    }
}

