/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.x509.Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.ssl.BcRevokedCertificateChecker;
import si.nevensrok.common.ssl.RevokedCertificate;
import si.nevensrok.common.ssl.RevokedCertificateChecker;
import si.nevensrok.common.utils.HashUtil;

public class ListRevokedCertificateChecker
implements RevokedCertificateChecker,
BcRevokedCertificateChecker {
    private static final Logger log = LoggerFactory.getLogger(ListRevokedCertificateChecker.class);
    private List<RevokedCertificate> revokedCertificates = new LinkedList<RevokedCertificate>();

    public ListRevokedCertificateChecker() {
    }

    public ListRevokedCertificateChecker(List<RevokedCertificate> revokedCertificates) {
        this.revokedCertificates.addAll(revokedCertificates);
    }

    public ListRevokedCertificateChecker(RevokedCertificate ... revokedCertificate) {
        for (RevokedCertificate r : revokedCertificate) {
            this.revokedCertificates.add(r);
        }
    }

    public void setRevokedCertificates(List<RevokedCertificate> revokedCertificates) {
        this.revokedCertificates.addAll(revokedCertificates);
    }

    public void addRevokedCertificate(RevokedCertificate ... revokedCertificate) {
        for (RevokedCertificate r : revokedCertificate) {
            this.revokedCertificates.add(r);
        }
    }

    @Override
    public boolean isCertificateRevoked(java.security.cert.Certificate certificate) {
        try {
            byte[] sha1sum = null;
            byte[] sha256sum = null;
            for (RevokedCertificate revokedCertificate : this.revokedCertificates) {
                boolean isRevoked = false;
                if (revokedCertificate.getSerialNumber() != null) {
                    X509Certificate cert = (X509Certificate)certificate;
                    if (!revokedCertificate.getSerialNumber().equals(cert.getSerialNumber())) continue;
                    isRevoked = true;
                }
                if (revokedCertificate.getSha1sum() != null) {
                    if (sha1sum == null) {
                        sha1sum = HashUtil.generateHash((byte[])certificate.getEncoded(), (HashUtil.HashType)HashUtil.HashType.SHA1);
                    }
                    if (!Arrays.equals(sha1sum, revokedCertificate.getSha1sum())) continue;
                    isRevoked = true;
                }
                if (revokedCertificate.getSha256sum() != null) {
                    if (sha256sum == null) {
                        sha256sum = HashUtil.generateHash((byte[])certificate.getEncoded(), (HashUtil.HashType)HashUtil.HashType.SHA256);
                    }
                    if (!Arrays.equals(sha256sum, revokedCertificate.getSha256sum())) continue;
                    isRevoked = true;
                }
                if (!isRevoked) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.error("Error checking if certificate is revoked", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean isCertificateRevoked(Certificate certificate) {
        try {
            byte[] sha1sum = null;
            byte[] sha256sum = null;
            for (RevokedCertificate revokedCertificate : this.revokedCertificates) {
                boolean isRevoked = false;
                if (revokedCertificate.getSerialNumber() != null) {
                    if (!revokedCertificate.getSerialNumber().equals(certificate.getSerialNumber().getValue())) continue;
                    isRevoked = true;
                }
                if (revokedCertificate.getSha1sum() != null) {
                    if (sha1sum == null) {
                        sha1sum = HashUtil.generateHash((byte[])certificate.getEncoded(), (HashUtil.HashType)HashUtil.HashType.SHA1);
                    }
                    if (!Arrays.equals(sha1sum, revokedCertificate.getSha1sum())) continue;
                    isRevoked = true;
                }
                if (revokedCertificate.getSha256sum() != null) {
                    if (sha256sum == null) {
                        sha256sum = HashUtil.generateHash((byte[])certificate.getEncoded(), (HashUtil.HashType)HashUtil.HashType.SHA256);
                    }
                    if (!Arrays.equals(sha256sum, revokedCertificate.getSha256sum())) continue;
                    isRevoked = true;
                }
                if (!isRevoked) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.error("Error checking if certificate is revoked", (Throwable)e);
        }
        return false;
    }
}

