/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.notifications;

import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.notifications.Notification;
import si.nevensrok.common.notifications.NotificationSender;
import si.nevensrok.common.notifications.pushover.PushoverNotificationSender;
import si.nevensrok.common.threads.ThreadUtil;

public abstract class BackgroundNotificationSender
implements NotificationSender,
InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(PushoverNotificationSender.class);
    private boolean active = true;
    private LinkedList<Notification> notificationList = new LinkedList();

    public void afterPropertiesSet() throws Exception {
        ThreadUtil.runInBackground(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LOGGER.info("Starting background notification sender thread");
                while (BackgroundNotificationSender.this.active) {
                    Notification notification = null;
                    LinkedList linkedList = BackgroundNotificationSender.this.notificationList;
                    synchronized (linkedList) {
                        while (BackgroundNotificationSender.this.notificationList.isEmpty() && BackgroundNotificationSender.this.active) {
                            try {
                                BackgroundNotificationSender.this.notificationList.wait();
                            }
                            catch (Exception exception) {}
                        }
                        if (!BackgroundNotificationSender.this.notificationList.isEmpty()) {
                            notification = (Notification)BackgroundNotificationSender.this.notificationList.removeFirst();
                        }
                    }
                    if (notification == null) continue;
                    try {
                        LOGGER.trace("Sending notification: {}", (Object)notification);
                        BackgroundNotificationSender.this.sendNotification(notification);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error while sending notification", (Throwable)e);
                    }
                }
                LOGGER.info("Stopping background notification sender thread");
            }
        }, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        this.active = false;
        LinkedList<Notification> linkedList = this.notificationList;
        synchronized (linkedList) {
            this.notificationList.clear();
            this.notificationList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendNotificationInBackground(Notification notification) {
        if (this.active) {
            LinkedList<Notification> linkedList = this.notificationList;
            synchronized (linkedList) {
                this.notificationList.add(notification);
                this.notificationList.notifyAll();
            }
        }
    }
}

