/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.executor;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import si.nevensrok.common.executor.FutureCompletedSpy;
import si.nevensrok.common.executor.TaskWrapper;

public class FutureWrapper<P, V>
extends TaskWrapper<P>
implements Future<V> {
    private Object result;
    private Throwable throwable;
    private boolean completed = false;
    private FutureCompletedSpy<V> futureCompletedSpy = null;
    private Thread thread = null;

    public FutureWrapper(Comparable<P> priority, long index, Object task) {
        super(priority, index, task);
    }

    public FutureWrapper(Comparable<P> priority, long index, Object task, FutureCompletedSpy<V> futureCompletedSpy) {
        super(priority, index, task);
        this.futureCompletedSpy = futureCompletedSpy;
    }

    public FutureWrapper(Comparable<P> priority, long index, Object task, Object returnResult) {
        super(priority, index, task);
        this.result = returnResult;
    }

    public synchronized void setThread(Thread thread) {
        this.thread = thread;
    }

    public synchronized void setDone() {
        this.completed = true;
        this.notifyAll();
        if (this.futureCompletedSpy != null) {
            this.futureCompletedSpy.setDone();
        }
    }

    public synchronized void setResult(Object result) {
        this.completed = true;
        this.result = result;
        this.notifyAll();
        if (this.futureCompletedSpy != null) {
            this.futureCompletedSpy.setResult(result);
        }
    }

    public synchronized void setThrowable(Throwable throwable) {
        this.completed = true;
        this.throwable = throwable;
        this.notifyAll();
        if (this.futureCompletedSpy != null) {
            this.futureCompletedSpy.setThrowable(throwable);
        }
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.completed || this.task == null) {
            return false;
        }
        this.task = null;
        this.notifyAll();
        if (mayInterruptIfRunning && this.thread != null) {
            this.thread.interrupt();
        }
        return true;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.task == null;
    }

    @Override
    public synchronized boolean isDone() {
        return this.completed;
    }

    @Override
    public synchronized V get() throws InterruptedException, ExecutionException {
        while (!this.completed) {
            if (this.task == null) {
                throw new CancellationException();
            }
            this.wait();
        }
        if (this.throwable != null) {
            throw new ExecutionException(this.throwable);
        }
        return (V)this.result;
    }

    @Override
    public synchronized V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.completed) {
            if (this.throwable != null) {
                throw new ExecutionException(this.throwable);
            }
            return (V)this.result;
        }
        long waitUntil = System.currentTimeMillis() + unit.toMillis(timeout);
        while (!this.completed) {
            if (this.task == null) {
                throw new CancellationException();
            }
            long waitTime = waitUntil - System.currentTimeMillis();
            if (waitTime <= 0L) {
                throw new TimeoutException();
            }
            this.wait(waitTime);
        }
        if (this.throwable != null) {
            throw new ExecutionException(this.throwable);
        }
        return (V)this.result;
    }
}

