/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.dataexport;

import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import si.nevensrok.common.dataexport.AbstractFileWriter;

public class XlsFileWriter
extends AbstractFileWriter {
    private HSSFWorkbook workbook;
    private HSSFSheet sheet;
    private int rownum = 0;
    private OutputStream outputStream;

    @Override
    public void init(OutputStream outputStream) throws Exception {
        this.outputStream = outputStream;
        this.workbook = new HSSFWorkbook();
        this.sheet = this.workbook.createSheet();
    }

    @Override
    public void close() throws Exception {
        this.workbook.write(this.outputStream);
    }

    @Override
    public void writeLine(String[] line) throws Exception {
        HSSFRow row = this.sheet.createRow(this.rownum++);
        for (int i = 0; i < line.length; ++i) {
            HSSFCell cell = row.createCell(i, 1);
            cell.setCellValue(line[i]);
        }
    }
}

