/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class PriorityBlockingQueue<E>
implements BlockingQueue<E> {
    private int queueSize;
    private TreeSet<E> data;

    public PriorityBlockingQueue() {
        this(Integer.MAX_VALUE);
    }

    public PriorityBlockingQueue(int queueSize) {
        if (queueSize < 0) {
            throw new IllegalArgumentException("Queue size must be value equal to 0 or greater");
        }
        this.queueSize = queueSize;
        this.data = new TreeSet();
    }

    @Override
    public synchronized boolean add(E e) {
        if (this.data.size() >= this.queueSize) {
            throw new IllegalStateException("Queue is full");
        }
        this.notifyAll();
        return this.data.add(e);
    }

    @Override
    public synchronized boolean offer(E e) {
        if (this.data.size() >= this.queueSize) {
            return false;
        }
        this.data.add(e);
        this.notifyAll();
        return true;
    }

    @Override
    public synchronized void put(E e) throws InterruptedException {
        while (this.data.size() >= this.queueSize) {
            this.wait();
        }
        this.data.add(e);
        this.notifyAll();
    }

    @Override
    public synchronized boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.data.size() < this.queueSize) {
            this.data.add(e);
            this.notifyAll();
            return true;
        }
        long waitUntil = System.currentTimeMillis() + unit.toMillis(timeout);
        while (this.data.size() >= this.queueSize) {
            long waitTime = waitUntil - System.currentTimeMillis();
            if (waitTime <= 0L) {
                return false;
            }
            this.wait(waitTime);
        }
        this.data.add(e);
        this.notifyAll();
        return true;
    }

    @Override
    public synchronized E take() throws InterruptedException {
        while (this.data.isEmpty()) {
            this.wait();
        }
        E item = this.data.first();
        this.data.remove(item);
        return item;
    }

    @Override
    public synchronized E poll(long timeout, TimeUnit unit) throws InterruptedException {
        if (!this.data.isEmpty()) {
            E item = this.data.first();
            this.data.remove(item);
            return item;
        }
        long waitUntil = System.currentTimeMillis() + unit.toMillis(timeout);
        while (this.data.isEmpty()) {
            long waitTime = waitUntil - System.currentTimeMillis();
            if (waitTime <= 0L) {
                return null;
            }
            this.wait(waitTime);
        }
        E item = this.data.first();
        this.data.remove(item);
        return item;
    }

    @Override
    public synchronized int remainingCapacity() {
        return this.queueSize - this.data.size();
    }

    @Override
    public synchronized boolean remove(Object o) {
        return this.data.remove(o);
    }

    @Override
    public synchronized boolean contains(Object o) {
        return this.data.contains(o);
    }

    @Override
    public synchronized int drainTo(Collection<? super E> c) {
        int counter = 0;
        while (!this.data.isEmpty()) {
            E item = this.data.first();
            this.data.remove(item);
            c.add(item);
            ++counter;
        }
        return counter;
    }

    @Override
    public synchronized int drainTo(Collection<? super E> c, int maxElements) {
        int counter;
        for (counter = 0; !this.data.isEmpty() && counter < maxElements; ++counter) {
            E item = this.data.first();
            this.data.remove(item);
            c.add(item);
        }
        return counter;
    }

    @Override
    public synchronized E remove() {
        if (this.data.isEmpty()) {
            throw new NoSuchElementException("Queue is empty");
        }
        E item = this.data.first();
        this.data.remove(item);
        return item;
    }

    @Override
    public synchronized E poll() {
        if (this.data.isEmpty()) {
            return null;
        }
        E item = this.data.first();
        this.data.remove(item);
        return item;
    }

    @Override
    public synchronized E element() {
        if (this.data.isEmpty()) {
            throw new NoSuchElementException("Queue is empty");
        }
        E item = this.data.first();
        return item;
    }

    @Override
    public synchronized E peek() {
        if (this.data.isEmpty()) {
            return null;
        }
        E item = this.data.first();
        return item;
    }

    @Override
    public synchronized int size() {
        return this.data.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public synchronized Iterator<E> iterator() {
        return this.data.iterator();
    }

    @Override
    public synchronized Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public synchronized <T> T[] toArray(T[] a) {
        return this.data.toArray(a);
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        return this.data.containsAll(c);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E item : c) {
            changed = this.add(item) || changed;
        }
        return changed;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        return this.data.removeAll(c);
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        return this.data.retainAll(c);
    }

    @Override
    public synchronized void clear() {
        this.data.clear();
    }
}

