/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.cache.redis;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import redis.clients.jedis.Jedis;
import si.nevensrok.common.cache.AbstractCacheManager;
import si.nevensrok.common.cache.CacheSettings;
import si.nevensrok.common.cache.redis.RedisCache;

public class RedisCacheManager
extends AbstractCacheManager
implements InitializingBean {
    private Jedis jedis;
    private String namePrefix = "cache.";
    private Map<String, RedisCache> cacheStore = new LinkedHashMap<String, RedisCache>();

    public Jedis getJedis() {
        return this.jedis;
    }

    public void setJedis(Jedis jedis) {
        this.jedis = jedis;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.jedis == null) {
            throw new IllegalArgumentException("Property 'jedis' must be specified");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getCache(String name) {
        RedisCache cache;
        Map<String, RedisCache> map = this.cacheStore;
        synchronized (map) {
            cache = this.cacheStore.get(name);
            if (cache == null) {
                CacheSettings settings = this.getCacheSettings().get(name);
                if (settings == null) {
                    settings = this.getDefaultCacheSettings();
                }
                cache = new RedisCache(name, settings, this.jedis, this.namePrefix);
                this.cacheStore.put(name, cache);
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getCacheNames() {
        Map<String, RedisCache> map = this.cacheStore;
        synchronized (map) {
            return new LinkedList<String>(this.cacheStore.keySet());
        }
    }
}

