/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal.duopresentation;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import si.nevensrok.jtekma.common.rules.DuoPresentationAttack;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.DuoPresentationPoints;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.gui.WindowKeyListener;
import si.nevensrok.jtekma.tabla.gui.duo.DuoPresentationPointsDocument;
import si.nevensrok.jtekma.tabla.gui.duo.DuoTextFieldKeyListener;
import si.nevensrok.jtekma.tabla.gui.horizontal.duopresentation.DuoPresentationPointsPanel;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class DuoPresentationPointsRow
extends JPanel {
    private JLabel rowLabel = new JLabel();
    private JTextField[] points = new JTextField[4];
    private int judge;
    private int row;
    private DuoPresentationPoints duoPresentationPoints;
    private TablaManager tablaManager;
    private boolean documentForFieldsSet = false;

    public DuoPresentationPointsRow(int judge, int row) {
        this.judge = judge;
        this.row = row;
        this.setLayout(new GridLayout(1, 5));
        this.rowLabel.setHorizontalAlignment(0);
        this.rowLabel.setText(String.valueOf(row));
        this.add(this.rowLabel);
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = new JTextField("0");
            this.points[i].setHorizontalAlignment(0);
            this.add(this.points[i]);
        }
    }

    public void setWindowKeyListener(WindowKeyListener windowKeyListener) {
        for (JTextField pointField : this.points) {
            pointField.addKeyListener(windowKeyListener);
        }
    }

    public void setDuoPresentationPoints(DuoPresentationPoints duoPresentationPoints) {
        this.duoPresentationPoints = duoPresentationPoints;
        this.setDocumentForFields();
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.tablaManager = tablaManager;
        this.setDocumentForFields();
    }

    public void setDuoFieldSelector(DuoPresentationPointsPanel duoPresentationPointsPanel) {
        for (JTextField pointField : this.points) {
            DuoTextFieldKeyListener duoTextFieldKeyListener = new DuoTextFieldKeyListener();
            duoTextFieldKeyListener.setDuoPresentationPointsPanel(duoPresentationPointsPanel);
            pointField.addKeyListener(duoTextFieldKeyListener);
        }
    }

    private void setDocumentForFields() {
        if (this.duoPresentationPoints == null || this.tablaManager == null) {
            return;
        }
        if (this.documentForFieldsSet) {
            return;
        }
        this.documentForFieldsSet = true;
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i].setDocument(new DuoPresentationPointsDocument(this.judge, this.row, i + 1, this.duoPresentationPoints, this.tablaManager));
        }
    }

    public void selectField(final int index) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DuoPresentationPointsRow.this.points[index - 1].requestFocus();
                DuoPresentationPointsRow.this.points[index - 1].setSelectionStart(0);
                DuoPresentationPointsRow.this.points[index - 1].setSelectionEnd(DuoPresentationPointsRow.this.points[index - 1].getText().length());
            }
        });
    }

    public int getSelectedField() {
        for (int part = 1; part <= 4; ++part) {
            if (!this.points[part - 1].hasFocus()) continue;
            return part;
        }
        return 0;
    }

    public void resetPoints() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int part = 1; part <= 4; ++part) {
                    if (DuoPresentationPointsRow.this.duoPresentationPoints != null) {
                        DuoPresentationPointsRow.this.points[part - 1].setText(Constants.FIGHT_POINTS_FORMAT.format(DuoPresentationPointsRow.this.duoPresentationPoints.getPoints(DuoPresentationPointsRow.this.judge, DuoPresentationPointsRow.this.row, part)));
                    }
                    FontSizeUtil.refitFontSize(Constants.FONT, DuoPresentationPointsRow.this.points[part - 1]);
                }
            }
        });
    }

    public void redrawElements() {
        final List<Object> attacks = this.duoPresentationPoints == null ? new ArrayList() : this.duoPresentationPoints.getAttacks();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DuoPresentationAttack duoPresentationAttack;
                if (attacks.isEmpty()) {
                    DuoPresentationPointsRow.this.rowLabel.setText(String.valueOf(DuoPresentationPointsRow.this.row));
                    for (JTextField pointField : DuoPresentationPointsRow.this.points) {
                        pointField.setEnabled(true);
                    }
                } else if (attacks.size() == 4) {
                    if (DuoPresentationPointsRow.this.row == 5 || DuoPresentationPointsRow.this.row == 6) {
                        DuoPresentationPointsRow.this.rowLabel.setText("X");
                        for (JTextField pointField : DuoPresentationPointsRow.this.points) {
                            pointField.setEnabled(false);
                        }
                    } else {
                        duoPresentationAttack = (DuoPresentationAttack)attacks.get(DuoPresentationPointsRow.this.row - 1);
                        DuoPresentationPointsRow.this.rowLabel.setText(duoPresentationAttack.getSeries().name() + duoPresentationAttack.getAttack());
                    }
                } else if (attacks.size() == 6) {
                    duoPresentationAttack = (DuoPresentationAttack)attacks.get(DuoPresentationPointsRow.this.row - 1);
                    DuoPresentationPointsRow.this.rowLabel.setText(duoPresentationAttack.getSeries().name() + duoPresentationAttack.getAttack());
                    if (DuoPresentationPointsRow.this.row == 5 || DuoPresentationPointsRow.this.row == 6) {
                        JTextField[] jTextFieldArray = DuoPresentationPointsRow.this.points;
                        int n = jTextFieldArray.length;
                        for (int pointField = 0; pointField < n; ++pointField) {
                            JTextField pointField2 = jTextFieldArray[pointField];
                            pointField2.setEnabled(true);
                        }
                    }
                }
                FontSizeUtil.refitFontSize(Constants.FONT, DuoPresentationPointsRow.this.rowLabel, "E");
                for (JTextField pointField : DuoPresentationPointsRow.this.points) {
                    FontSizeUtil.refitFontSize(Constants.FONT, pointField);
                }
                DuoPresentationPointsRow.this.repaint();
            }
        });
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.rowLabel != null) {
            this.rowLabel.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.rowLabel != null) {
            this.rowLabel.setForeground(fg);
        }
    }
}

