/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal.duo2023;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.common.rules.DuoPresentationAttack;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.Duo2023Points;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.gui.WindowKeyListener;
import si.nevensrok.jtekma.tabla.gui.duo.Duo2023PointsDocument;
import si.nevensrok.jtekma.tabla.gui.duo.DuoTextFieldKeyListener;
import si.nevensrok.jtekma.tabla.gui.horizontal.duo2023.Duo2023FieldSelector;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class Duo2023PointsRow
extends JPanel {
    private JLabel rowLabel = new JLabel();
    private JTextField[] points = new JTextField[4];
    private CompetitorType competitorType;
    private int judge;
    private int row;
    private Duo2023Points duo2023Points;
    private TablaManager tablaManager;
    private boolean documentForFieldsSet = false;

    public Duo2023PointsRow(CompetitorType competitorType, int judge, int row) {
        this.competitorType = competitorType;
        this.judge = judge;
        this.row = row;
        this.setLayout(new GridLayout(1, 5));
        this.rowLabel.setHorizontalAlignment(0);
        this.rowLabel.setText(String.valueOf(row));
        this.add(this.rowLabel);
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = new JTextField("0");
            this.points[i].setHorizontalAlignment(0);
            this.add(this.points[i]);
        }
    }

    public void setWindowKeyListener(WindowKeyListener windowKeyListener) {
        for (JTextField pointField : this.points) {
            pointField.addKeyListener(windowKeyListener);
        }
    }

    public void setDuo2023Points(Duo2023Points duo2023Points) {
        this.duo2023Points = duo2023Points;
        this.setDocumentForFields();
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.tablaManager = tablaManager;
        this.setDocumentForFields();
    }

    public void setDuoFieldSelector(Duo2023FieldSelector duo2023FieldSelector) {
        for (JTextField pointField : this.points) {
            DuoTextFieldKeyListener duoTextFieldKeyListener = new DuoTextFieldKeyListener();
            duoTextFieldKeyListener.setDuo2023FieldSelector(duo2023FieldSelector);
            pointField.addKeyListener(duoTextFieldKeyListener);
        }
    }

    private void setDocumentForFields() {
        if (this.duo2023Points == null || this.tablaManager == null) {
            return;
        }
        if (this.documentForFieldsSet) {
            return;
        }
        this.documentForFieldsSet = true;
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i].setDocument(new Duo2023PointsDocument(this.competitorType, this.judge, this.row, i + 1, this.duo2023Points, this.tablaManager));
        }
    }

    public void selectField(final int index) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Duo2023PointsRow.this.points[index - 1].requestFocus();
                Duo2023PointsRow.this.points[index - 1].setSelectionStart(0);
                Duo2023PointsRow.this.points[index - 1].setSelectionEnd(Duo2023PointsRow.this.points[index - 1].getText().length());
            }
        });
    }

    public int getSelectedField() {
        for (int part = 1; part <= 4; ++part) {
            if (!this.points[part - 1].hasFocus()) continue;
            return part;
        }
        return 0;
    }

    public void resetPoints() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int part = 1; part <= 4; ++part) {
                    if (Duo2023PointsRow.this.duo2023Points != null) {
                        if (Duo2023PointsRow.this.competitorType == CompetitorType.COMPETITOR1) {
                            Duo2023PointsRow.this.points[part - 1].setText(Constants.FIGHT_POINTS_FORMAT.format(Duo2023PointsRow.this.duo2023Points.getPoints1(Duo2023PointsRow.this.judge, Duo2023PointsRow.this.row, part)));
                        } else if (Duo2023PointsRow.this.competitorType == CompetitorType.COMPETITOR2) {
                            Duo2023PointsRow.this.points[part - 1].setText(Constants.FIGHT_POINTS_FORMAT.format(Duo2023PointsRow.this.duo2023Points.getPoints2(Duo2023PointsRow.this.judge, Duo2023PointsRow.this.row, part)));
                        }
                    }
                    FontSizeUtil.refitFontSize(Constants.FONT, Duo2023PointsRow.this.points[part - 1]);
                }
            }
        });
    }

    public void redrawElements() {
        final List<Object> attacks = this.duo2023Points == null ? new ArrayList() : this.duo2023Points.getAttacks();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DuoPresentationAttack duoPresentationAttack;
                if (attacks.isEmpty()) {
                    Duo2023PointsRow.this.rowLabel.setText(String.valueOf(Duo2023PointsRow.this.row));
                    for (JTextField pointField : Duo2023PointsRow.this.points) {
                        pointField.setEnabled(true);
                    }
                } else if (attacks.size() == 4) {
                    if (Duo2023PointsRow.this.row == 5 || Duo2023PointsRow.this.row == 6) {
                        Duo2023PointsRow.this.rowLabel.setText("X");
                        for (JTextField pointField : Duo2023PointsRow.this.points) {
                            pointField.setEnabled(false);
                        }
                    } else {
                        duoPresentationAttack = (DuoPresentationAttack)attacks.get(Duo2023PointsRow.this.row - 1);
                        Duo2023PointsRow.this.rowLabel.setText(duoPresentationAttack.getSeries().name() + duoPresentationAttack.getAttack());
                    }
                } else if (attacks.size() == 6) {
                    duoPresentationAttack = (DuoPresentationAttack)attacks.get(Duo2023PointsRow.this.row - 1);
                    Duo2023PointsRow.this.rowLabel.setText(duoPresentationAttack.getSeries().name() + duoPresentationAttack.getAttack());
                    if (Duo2023PointsRow.this.row == 5 || Duo2023PointsRow.this.row == 6) {
                        JTextField[] jTextFieldArray = Duo2023PointsRow.this.points;
                        int n = jTextFieldArray.length;
                        for (int pointField = 0; pointField < n; ++pointField) {
                            JTextField pointField2 = jTextFieldArray[pointField];
                            pointField2.setEnabled(true);
                        }
                    }
                }
                FontSizeUtil.refitFontSize(Constants.FONT, Duo2023PointsRow.this.rowLabel, "E");
                for (JTextField pointField : Duo2023PointsRow.this.points) {
                    FontSizeUtil.refitFontSize(Constants.FONT, pointField);
                }
            }
        });
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.rowLabel != null) {
            this.rowLabel.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.rowLabel != null) {
            this.rowLabel.setForeground(fg);
        }
    }
}

