/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal.duo2023;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.Duo2023Points;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.gui.WindowKeyListener;
import si.nevensrok.jtekma.tabla.gui.horizontal.duo2023.Duo2023FieldSelector;
import si.nevensrok.jtekma.tabla.gui.horizontal.duo2023.Duo2023PointsRow;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class Duo2023JudgePoints
extends JPanel {
    private int judge;
    private TablaManager tablaManager;
    private JLabel titleLabel = new JLabel();
    private Duo2023PointsRow[] rows = new Duo2023PointsRow[6];

    public Duo2023JudgePoints(CompetitorType competitorType, int judge) {
        this.judge = judge;
        this.setLayout(new GridLayout(7, 1));
        this.titleLabel.setHorizontalAlignment(0);
        this.add(this.titleLabel);
        for (int i = 0; i < 6; ++i) {
            this.rows[i] = new Duo2023PointsRow(competitorType, judge, i + 1);
            this.add(this.rows[i]);
        }
    }

    public void redrawElements() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Duo2023JudgePoints.this.titleLabel.setText(Duo2023JudgePoints.this.tablaManager.getLanguageText("text.judge") + " " + String.valueOf(Duo2023JudgePoints.this.judge));
                FontSizeUtil.refitFontSize(Constants.FONT, Duo2023JudgePoints.this.titleLabel);
            }
        });
        for (Duo2023PointsRow duoPresentationPointsRow : this.rows) {
            duoPresentationPointsRow.redrawElements();
        }
    }

    public void resetPoints() {
        for (Duo2023PointsRow duoPresentationPointsRow : this.rows) {
            duoPresentationPointsRow.resetPoints();
        }
    }

    public void setWindowKeyListener(WindowKeyListener windowKeyListener) {
        for (Duo2023PointsRow duoPresentationPointsRow : this.rows) {
            duoPresentationPointsRow.setWindowKeyListener(windowKeyListener);
        }
    }

    public void setDuo2023Points(Duo2023Points duo2023Points) {
        for (Duo2023PointsRow duoPresentationPointsRow : this.rows) {
            duoPresentationPointsRow.setDuo2023Points(duo2023Points);
        }
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.tablaManager = tablaManager;
        for (Duo2023PointsRow duoPresentationPointsRow : this.rows) {
            duoPresentationPointsRow.setTablaManager(tablaManager);
        }
    }

    public void setDuoFieldSelector(Duo2023FieldSelector duo2023FieldSelector) {
        for (Duo2023PointsRow duoPresentationPointsRow : this.rows) {
            duoPresentationPointsRow.setDuoFieldSelector(duo2023FieldSelector);
        }
    }

    public void selectField(int index) {
        int row = (index - 1) / 4;
        this.rows[row].selectField((index - 1) % 4 + 1);
    }

    public int getSelectedField() {
        for (int row = 0; row < this.rows.length; ++row) {
            int sel = this.rows[row].getSelectedField();
            if (sel <= 0) continue;
            return row * 4 + sel;
        }
        return 0;
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.titleLabel != null) {
            this.titleLabel.setBackground(bg);
        }
        if (this.rows != null) {
            for (Duo2023PointsRow row : this.rows) {
                if (row == null) continue;
                row.setBackground(bg);
            }
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.titleLabel != null) {
            this.titleLabel.setForeground(fg);
        }
        if (this.rows != null) {
            for (Duo2023PointsRow row : this.rows) {
                if (row == null) continue;
                row.setForeground(fg);
            }
        }
    }
}

