/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal;

import java.awt.EventQueue;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.Duo2023Points;
import si.nevensrok.jtekma.tabla.common.DuoPoints;
import si.nevensrok.jtekma.tabla.common.DuoPresentationPoints;
import si.nevensrok.jtekma.tabla.common.FightPoints;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.common.NewazaPoints;
import si.nevensrok.jtekma.tabla.common.TableType;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.fw.TimeTracker;
import si.nevensrok.jtekma.tabla.gui.MatchPanel;
import si.nevensrok.jtekma.tabla.gui.TextSource;
import si.nevensrok.jtekma.tabla.gui.WindowKeyListener;
import si.nevensrok.jtekma.tabla.gui.horizontal.CompetitorPanel;
import si.nevensrok.jtekma.tabla.gui.horizontal.InfoPanel;
import si.nevensrok.jtekma.tabla.gui.horizontal.duo.DuoFieldSelector;
import si.nevensrok.jtekma.tabla.gui.horizontal.duo2023.Duo2023FieldSelector;

public class HorizontalMatchPanel
extends JPanel
implements InitializingBean,
MatchPanel {
    private CompetitorPanel competitor1Panel = new CompetitorPanel(CompetitorType.COMPETITOR1);
    private CompetitorPanel competitor2Panel = new CompetitorPanel(CompetitorType.COMPETITOR2);
    private InfoPanel infoPanel = new InfoPanel();
    private MatchData matchData;
    private JFrame mainWindow;
    private TextSource textSource;
    private DuoFieldSelector duoFieldSelector;
    private Duo2023FieldSelector duo2023FieldSelector;

    public HorizontalMatchPanel() {
        this.setLayout(null);
        this.competitor1Panel.setBackground(Constants.COMPETITOR_1_BG_COLOR);
        this.competitor1Panel.setForeground(Constants.COMPETITOR_1_FG_COLOR);
        this.add(this.competitor1Panel);
        this.competitor2Panel.setBackground(Constants.COMPETITOR_2_BG_COLOR);
        this.competitor2Panel.setForeground(Constants.COMPETITOR_2_FG_COLOR);
        this.add(this.competitor2Panel);
        this.infoPanel.setBackground(Constants.INFO_BG_COLOR);
        this.infoPanel.setForeground(Constants.INFO_FG_COLOR);
        this.add(this.infoPanel);
        this.duoFieldSelector = new DuoFieldSelector();
        this.duoFieldSelector.setCompetitor1Panel(this.competitor1Panel);
        this.duoFieldSelector.setCompetitor2Panel(this.competitor2Panel);
        this.duo2023FieldSelector = new Duo2023FieldSelector();
        this.duo2023FieldSelector.setCompetitor1Panel(this.competitor1Panel);
        this.duo2023FieldSelector.setCompetitor2Panel(this.competitor2Panel);
        this.competitor1Panel.setDuoFieldSelector(this.duoFieldSelector);
        this.competitor2Panel.setDuoFieldSelector(this.duoFieldSelector);
        this.competitor1Panel.setDuo2023FieldSelector(this.duo2023FieldSelector);
        this.competitor2Panel.setDuo2023FieldSelector(this.duo2023FieldSelector);
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
        this.infoPanel.setMatchData(matchData);
        this.competitor1Panel.setMatchData(matchData);
        this.competitor2Panel.setMatchData(matchData);
        this.duoFieldSelector.setMatchData(matchData);
        this.duo2023FieldSelector.setMatchData(matchData);
    }

    public void setFightPoints(FightPoints fightPoints) {
        this.competitor1Panel.setFightPoints(fightPoints);
        this.competitor2Panel.setFightPoints(fightPoints);
    }

    public void setDuoPoints(DuoPoints duoPoints) {
        this.competitor1Panel.setDuoPoints(duoPoints);
        this.competitor2Panel.setDuoPoints(duoPoints);
    }

    public void setDuo2023Points(Duo2023Points duo2023Points) {
        this.competitor1Panel.setDuo2023Points(duo2023Points);
        this.competitor2Panel.setDuo2023Points(duo2023Points);
    }

    public void setDuoPresentationPoints(DuoPresentationPoints duoPresentationPoints) {
        this.competitor1Panel.setDuoPresentationPoints(duoPresentationPoints);
    }

    public void setNewazaPoints(NewazaPoints newazaPoints) {
        this.competitor1Panel.setNewazaPoints(newazaPoints);
        this.competitor2Panel.setNewazaPoints(newazaPoints);
    }

    public void setTimeTracker(TimeTracker timeTracker) {
        this.infoPanel.setTimeTracker(timeTracker);
    }

    public void setMainWindow(JFrame mainWindow) {
        this.mainWindow = mainWindow;
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.infoPanel.setTablaManager(tablaManager);
        this.competitor1Panel.setTablaManager(tablaManager);
        this.competitor2Panel.setTablaManager(tablaManager);
    }

    public void setWindowKeyListener(WindowKeyListener windowKeyListener) {
        this.competitor1Panel.setWindowKeyListener(windowKeyListener);
        this.competitor2Panel.setWindowKeyListener(windowKeyListener);
    }

    public void setTextSource(TextSource textSource) {
        this.textSource = textSource;
        this.competitor1Panel.setTextSource(textSource);
        this.competitor2Panel.setTextSource(textSource);
    }

    public void afterPropertiesSet() throws Exception {
        this.redrawElements();
    }

    @Override
    public void redrawElements() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                int width = HorizontalMatchPanel.this.getWidth();
                int height = HorizontalMatchPanel.this.getHeight();
                int playerPanelHeight = (int)Math.floor((float)height * 0.38f);
                if (HorizontalMatchPanel.this.matchData.getTableType() == TableType.DUO_PRESENTATION) {
                    HorizontalMatchPanel.this.competitor1Panel.setLocation(0, 0);
                    HorizontalMatchPanel.this.competitor1Panel.setSize(width, playerPanelHeight * 2);
                    HorizontalMatchPanel.this.competitor2Panel.setLocation(0, 0);
                    HorizontalMatchPanel.this.competitor2Panel.setSize(0, 0);
                } else if (!HorizontalMatchPanel.this.matchData.isFlipCompetitors()) {
                    HorizontalMatchPanel.this.competitor2Panel.setLocation(0, 0);
                    HorizontalMatchPanel.this.competitor2Panel.setSize(width, playerPanelHeight);
                    HorizontalMatchPanel.this.competitor1Panel.setSize(width, playerPanelHeight);
                    HorizontalMatchPanel.this.competitor1Panel.setLocation(0, playerPanelHeight);
                } else {
                    HorizontalMatchPanel.this.competitor1Panel.setLocation(0, 0);
                    HorizontalMatchPanel.this.competitor1Panel.setSize(width, playerPanelHeight);
                    HorizontalMatchPanel.this.competitor2Panel.setSize(width, playerPanelHeight);
                    HorizontalMatchPanel.this.competitor2Panel.setLocation(0, playerPanelHeight);
                }
                int infoPanelHeight = height - 2 * playerPanelHeight;
                HorizontalMatchPanel.this.infoPanel.setSize(width, infoPanelHeight);
                HorizontalMatchPanel.this.infoPanel.setLocation(0, playerPanelHeight * 2);
                HorizontalMatchPanel.this.competitor1Panel.setCompetitorName(HorizontalMatchPanel.this.matchData.getName1());
                HorizontalMatchPanel.this.competitor1Panel.setCompetitorClub(HorizontalMatchPanel.this.matchData.getClub1());
                HorizontalMatchPanel.this.competitor2Panel.setCompetitorName(HorizontalMatchPanel.this.matchData.getName2());
                HorizontalMatchPanel.this.competitor2Panel.setCompetitorClub(HorizontalMatchPanel.this.matchData.getClub2());
                if (HorizontalMatchPanel.this.matchData.getTableType() == TableType.FIGHT) {
                    HorizontalMatchPanel.this.mainWindow.requestFocus();
                } else if (HorizontalMatchPanel.this.matchData.getTableType() == TableType.NEWAZA) {
                    HorizontalMatchPanel.this.mainWindow.requestFocus();
                }
                HorizontalMatchPanel.this.competitor1Panel.redrawElements();
                HorizontalMatchPanel.this.competitor2Panel.redrawElements();
                HorizontalMatchPanel.this.infoPanel.redrawElements();
                HorizontalMatchPanel.this.revalidate();
                HorizontalMatchPanel.this.repaint();
            }
        });
    }

    @Override
    public void setPoints1(float points) {
        this.competitor1Panel.setPoints(points);
    }

    @Override
    public void setPoints2(float points) {
        this.competitor2Panel.setPoints(points);
    }

    @Override
    public void setWinner1() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                HorizontalMatchPanel.this.competitor1Panel.setCompetitorName(HorizontalMatchPanel.this.textSource.getLanguageText("text.winner"));
                HorizontalMatchPanel.this.competitor1Panel.setCompetitorClub("");
                HorizontalMatchPanel.this.competitor2Panel.setCompetitorName("");
                HorizontalMatchPanel.this.competitor2Panel.setCompetitorClub("");
            }
        });
    }

    @Override
    public void setWinner2() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                HorizontalMatchPanel.this.competitor1Panel.setCompetitorName("");
                HorizontalMatchPanel.this.competitor1Panel.setCompetitorClub("");
                HorizontalMatchPanel.this.competitor2Panel.setCompetitorName(HorizontalMatchPanel.this.textSource.getLanguageText("text.winner"));
                HorizontalMatchPanel.this.competitor2Panel.setCompetitorClub("");
            }
        });
    }

    @Override
    public void resetDuoPoints() {
        this.competitor1Panel.resetDuoPoints();
        this.competitor2Panel.resetDuoPoints();
    }

    @Override
    public void recalculateDuoPoints() {
        this.competitor1Panel.recalculateDuoPoints();
        this.competitor2Panel.recalculateDuoPoints();
    }

    @Override
    public void selectFirstDuoField() {
        this.competitor1Panel.selectFirstDuoField();
    }
}

