/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import si.nevensrok.common.objects.ObjectToString;
import si.nevensrok.jtekma.common.matches.MatchPoint;
import si.nevensrok.jtekma.common.matches.PointType;
import si.nevensrok.jtekma.common.matches.Series;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.common.rules.DuoPresentationAttack;

public class Duo2023Points
implements Serializable {
    private static final long serialVersionUID = -2472505575589345038L;
    private int[][][] points1 = new int[3][6][4];
    private int[][][] points2 = new int[3][6][4];
    private int penalty1 = 0;
    private int penalty2 = 0;
    private List<DuoPresentationAttack> attacks = new ArrayList<DuoPresentationAttack>();

    public List<DuoPresentationAttack> getAttacks() {
        return this.attacks;
    }

    public int getPoints1(int judge, int row, int part) {
        return this.points1[judge - 1][row - 1][part - 1];
    }

    public void setPoints1(int judge, int row, int part, int p) {
        this.points1[judge - 1][row - 1][part - 1] = p;
    }

    public int getPoints2(int judge, int row, int part) {
        return this.points2[judge - 1][row - 1][part - 1];
    }

    public void setPoints2(int judge, int row, int part, int p) {
        this.points2[judge - 1][row - 1][part - 1] = p;
    }

    public int getPenalty1() {
        return this.penalty1;
    }

    public void setPenalty1(int p) {
        this.penalty1 = p;
    }

    public int getPenalty2() {
        return this.penalty2;
    }

    public void setPenalty2(int p) {
        this.penalty2 = p;
    }

    public int getSum1() {
        int sum = 0;
        for (int judge = 1; judge <= 3; ++judge) {
            for (int attack = 1; attack <= 6; ++attack) {
                for (int part = 1; part <= 4; ++part) {
                    sum += this.points1[judge - 1][attack - 1][part - 1];
                }
            }
        }
        if ((sum -= this.penalty1) < 0) {
            sum = 0;
        }
        return sum;
    }

    public int getSum2() {
        int sum = 0;
        for (int judge = 1; judge <= 3; ++judge) {
            for (int attack = 1; attack <= 6; ++attack) {
                for (int part = 1; part <= 4; ++part) {
                    sum += this.points1[judge - 1][attack - 1][part - 1];
                }
            }
        }
        if ((sum -= this.penalty2) < 0) {
            sum = 0;
        }
        return sum;
    }

    public Set<MatchPoint> getMatchPoints(List<DuoPresentationAttack> attacks) {
        HashSet<MatchPoint> matchPoints = new HashSet<MatchPoint>();
        for (int judge = 1; judge <= 3; ++judge) {
            for (int row = 0; row < attacks.size(); ++row) {
                DuoPresentationAttack duoPresentationAttack = attacks.get(row);
                for (int part = 1; part <= 4; ++part) {
                    MatchPoint matchPoint = new MatchPoint();
                    matchPoint.setCompetitor(CompetitorType.COMPETITOR1);
                    matchPoint.setPointType(PointType.JUDGE);
                    matchPoint.setJudge(Integer.valueOf(judge));
                    matchPoint.setSeries(Series.valueOf((String)duoPresentationAttack.getSeries().name()));
                    matchPoint.setAttack(duoPresentationAttack.getAttack());
                    matchPoint.setPart(Integer.valueOf(part));
                    matchPoint.setPoints(Float.valueOf(this.points1[judge - 1][row][part - 1]));
                    matchPoints.add(matchPoint);
                    matchPoint = new MatchPoint();
                    matchPoint.setCompetitor(CompetitorType.COMPETITOR2);
                    matchPoint.setPointType(PointType.JUDGE);
                    matchPoint.setJudge(Integer.valueOf(judge));
                    matchPoint.setSeries(Series.valueOf((String)duoPresentationAttack.getSeries().name()));
                    matchPoint.setAttack(duoPresentationAttack.getAttack());
                    matchPoint.setPart(Integer.valueOf(part));
                    matchPoint.setPoints(Float.valueOf(this.points2[judge - 1][row][part - 1]));
                    matchPoints.add(matchPoint);
                }
            }
        }
        MatchPoint penaltyPoint1 = new MatchPoint();
        penaltyPoint1.setCompetitor(CompetitorType.COMPETITOR1);
        penaltyPoint1.setPointType(PointType.PENALTY);
        penaltyPoint1.setPoints(Float.valueOf(this.penalty1));
        matchPoints.add(penaltyPoint1);
        MatchPoint penaltyPoint2 = new MatchPoint();
        penaltyPoint2.setCompetitor(CompetitorType.COMPETITOR2);
        penaltyPoint2.setPointType(PointType.PENALTY);
        penaltyPoint2.setPoints(Float.valueOf(this.penalty2));
        matchPoints.add(penaltyPoint2);
        return matchPoints;
    }

    public void setAttacks(Collection<DuoPresentationAttack> attacks) {
        this.attacks = new ArrayList<DuoPresentationAttack>(attacks);
    }

    public void setMatchPoints(Set<MatchPoint> matchPoints, Collection<DuoPresentationAttack> attacks) {
        int judge;
        this.attacks = new ArrayList<DuoPresentationAttack>(attacks);
        for (judge = 1; judge <= 3; ++judge) {
            for (int row = 0; row < 6; ++row) {
                for (int part = 1; part <= 4; ++part) {
                    this.points1[judge - 1][row][part - 1] = 0;
                    this.points2[judge - 1][row][part - 1] = 0;
                }
            }
        }
        for (judge = 1; judge <= 3; ++judge) {
            int j = judge;
            for (int row = 0; row < attacks.size(); ++row) {
                DuoPresentationAttack duoPresentationAttack = this.attacks.get(row);
                for (int part = 1; part <= 4; ++part) {
                    int p = part;
                    MatchPoint matchPoint = matchPoints.stream().filter(mp -> mp.getPointType() == PointType.JUDGE && mp.getCompetitor() == CompetitorType.COMPETITOR1 && mp.getJudge() == j && mp.getSeries().name().equals(duoPresentationAttack.getSeries().name()) && mp.getAttack().intValue() == duoPresentationAttack.getAttack().intValue() && mp.getPart() == p).findFirst().orElse(null);
                    if (matchPoint != null) {
                        this.points1[judge - 1][row][part - 1] = matchPoint.getPoints().intValue();
                    }
                    if ((matchPoint = (MatchPoint)matchPoints.stream().filter(mp -> mp.getPointType() == PointType.JUDGE && mp.getCompetitor() == CompetitorType.COMPETITOR2 && mp.getJudge() == j && mp.getSeries().name().equals(duoPresentationAttack.getSeries().name()) && mp.getAttack().intValue() == duoPresentationAttack.getAttack().intValue() && mp.getPart() == p).findFirst().orElse(null)) == null) continue;
                    this.points2[judge - 1][row][part - 1] = matchPoint.getPoints().intValue();
                }
            }
        }
        MatchPoint penaltyPoint1 = matchPoints.stream().filter(mp -> mp.getCompetitor() == CompetitorType.COMPETITOR1 && mp.getPointType() == PointType.PENALTY).findFirst().orElse(null);
        this.penalty1 = penaltyPoint1 != null ? penaltyPoint1.getPoints().intValue() : 0;
        MatchPoint penaltyPoint2 = matchPoints.stream().filter(mp -> mp.getCompetitor() == CompetitorType.COMPETITOR2 && mp.getPointType() == PointType.PENALTY).findFirst().orElse(null);
        this.penalty2 = penaltyPoint2 != null ? penaltyPoint2.getPoints().intValue() : 0;
    }

    public String toString() {
        return new ObjectToString(Duo2023Points.class).addProperty("points1", (Object[])this.points1).addProperty("points2", (Object[])this.points2).addProperty("penalty1", this.penalty1).addProperty("penalty2", this.penalty2).addProperty("attacks", this.attacks).generateString();
    }
}

