/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.shape;

import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.openpisces.AlphaConsumer;
import com.sun.openpisces.Renderer;
import com.sun.prism.BasicStroke;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.shape.MaskData;
import com.sun.prism.impl.shape.OpenPiscesPrismUtils;
import com.sun.prism.impl.shape.ShapeRasterizer;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class OpenPiscesRasterizer
implements ShapeRasterizer {
    private static MaskData emptyData = MaskData.create(new byte[1], 0, 0, 1, 1);
    private static Consumer savedConsumer;

    @Override
    public MaskData getMaskData(Shape shape, BasicStroke stroke, RectBounds xformBounds, BaseTransform xform, boolean close, boolean antialiasedShape) {
        Rectangle rclip;
        if (stroke != null && stroke.getType() != 0) {
            shape = stroke.createStrokedShape(shape);
            stroke = null;
        }
        if (xformBounds == null) {
            if (stroke != null) {
                shape = stroke.createStrokedShape(shape);
                stroke = null;
            }
            xformBounds = new RectBounds();
            xformBounds = (RectBounds)xform.transform(shape.getBounds(), xformBounds);
        }
        if ((rclip = new Rectangle(xformBounds)).isEmpty()) {
            return emptyData;
        }
        Renderer renderer = null;
        if (shape instanceof Path2D) {
            renderer = OpenPiscesPrismUtils.setupRenderer((Path2D)shape, stroke, xform, rclip, antialiasedShape);
        }
        if (renderer == null) {
            renderer = OpenPiscesPrismUtils.setupRenderer(shape, stroke, xform, rclip, antialiasedShape);
        }
        int outpix_xmin = renderer.getOutpixMinX();
        int outpix_ymin = renderer.getOutpixMinY();
        int outpix_xmax = renderer.getOutpixMaxX();
        int outpix_ymax = renderer.getOutpixMaxY();
        int w = outpix_xmax - outpix_xmin;
        int h = outpix_ymax - outpix_ymin;
        if (w <= 0 || h <= 0) {
            return emptyData;
        }
        Consumer consumer = savedConsumer;
        if (consumer == null || w * h > consumer.getAlphaLength()) {
            int csize = w * h + 4095 & 0xFFFFF000;
            savedConsumer = consumer = new Consumer(csize);
            if (PrismSettings.verbose) {
                System.out.println("new alphas");
            }
        }
        consumer.setBoundsNoClone(outpix_xmin, outpix_ymin, w, h);
        renderer.produceAlphas(consumer);
        return consumer.getMaskData();
    }

    private static class Consumer
    implements AlphaConsumer {
        static byte[] savedAlphaMap;
        int x;
        int y;
        int width;
        int height;
        byte[] alphas;
        byte[] alphaMap;
        ByteBuffer alphabuffer;
        MaskData maskdata = new MaskData();

        public Consumer(int alphalen) {
            this.alphas = new byte[alphalen];
            this.alphabuffer = ByteBuffer.wrap(this.alphas);
        }

        public void setBoundsNoClone(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
            this.maskdata.update(this.alphabuffer, x, y, w, h);
        }

        @Override
        public int getOriginX() {
            return this.x;
        }

        @Override
        public int getOriginY() {
            return this.y;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        public byte[] getAlphasNoClone() {
            return this.alphas;
        }

        public int getAlphaLength() {
            return this.alphas.length;
        }

        public MaskData getMaskData() {
            return this.maskdata;
        }

        @Override
        public void setMaxAlpha(int maxalpha) {
            byte[] map = savedAlphaMap;
            if (map == null || map.length != maxalpha + 1) {
                map = new byte[maxalpha + 1];
                for (int i = 0; i <= maxalpha; ++i) {
                    map[i] = (byte)((i * 255 + maxalpha / 2) / maxalpha);
                }
                savedAlphaMap = map;
            }
            this.alphaMap = map;
        }

        @Override
        public void setAndClearRelativeAlphas(int[] alphaRow, int pix_y, int pix_from, int pix_to) {
            int w = this.width;
            int off = (pix_y - this.y) * w;
            byte[] out = this.alphas;
            byte[] map = this.alphaMap;
            int a = 0;
            for (int i = 0; i < w; ++i) {
                alphaRow[i] = 0;
                out[off + i] = map[a += alphaRow[i]];
            }
        }

        public void setAndClearRelativeAlphas2(int[] alphaDeltas, int pix_y, int pix_from, int pix_to) {
            if (pix_to >= pix_from) {
                int i;
                byte[] out = this.alphas;
                byte[] map = this.alphaMap;
                int from = pix_from - this.x;
                int to = pix_to - this.x;
                int w = this.width;
                int off = (pix_y - this.y) * w;
                for (i = 0; i < from; ++i) {
                    out[off + i] = 0;
                }
                int curAlpha = 0;
                while (i <= to) {
                    byte a;
                    alphaDeltas[i] = 0;
                    out[off + i] = a = map[curAlpha += alphaDeltas[i]];
                    ++i;
                }
                alphaDeltas[i] = 0;
                while (i < w) {
                    out[off + i] = 0;
                    ++i;
                }
            } else {
                Arrays.fill(alphaDeltas, 0);
            }
        }
    }
}

