/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene;

import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Camera;
import javafx.scene.Node;

public class CameraHelper {
    private static CameraAccessor cameraAccessor;

    private CameraHelper() {
    }

    public static Point2D project(Camera camera, Point3D p) {
        return cameraAccessor.project(camera, p);
    }

    public static Point2D pickNodeXYPlane(Camera camera, Node node, double x, double y) {
        return cameraAccessor.pickNodeXYPlane(camera, node, x, y);
    }

    public static Point3D pickProjectPlane(Camera camera, double x, double y) {
        return cameraAccessor.pickProjectPlane(camera, x, y);
    }

    public static void setCameraAccessor(CameraAccessor newAccessor) {
        if (cameraAccessor != null) {
            throw new IllegalStateException();
        }
        cameraAccessor = newAccessor;
    }

    private static void forceInit(Class<?> classToInit) {
        try {
            Class.forName(classToInit.getName(), true, classToInit.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        CameraHelper.forceInit(Camera.class);
    }

    public static interface CameraAccessor {
        public Point2D project(Camera var1, Point3D var2);

        public Point2D pickNodeXYPlane(Camera var1, Node var2, double var3, double var5);

        public Point3D pickProjectPlane(Camera var1, double var2, double var4);
    }
}

