/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.tcp;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.network.NetworkException;
import si.nevensrok.common.network.NetworkMessageHandler;
import si.nevensrok.common.network.NetworkMessenger;
import si.nevensrok.common.network.tcp.DisconnectListener;
import si.nevensrok.common.network.tcp.TcpNetworkConnection;
import si.nevensrok.common.utils.CloseUtil;

public class TcpNetworkClient
implements NetworkMessenger,
InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpNetworkClient.class);
    private boolean active = false;
    private String address;
    private Integer port;
    private int connectTimeout = 10000;
    private int reconnectTimeout = 3000;
    private String localAddress = null;
    private Integer localPort = null;
    private int maxMessageSize = 0x10000000;
    private int chunkSize = 0x200000;
    private final Object connectedMonitor = new Object();
    private TcpNetworkConnection tcpNetworkConnection = null;
    private boolean reconnecting = false;
    private final Object reconnectingMonitor = new Object();
    private NetworkMessageHandler networkMessageHandler = null;
    private Executor executor = null;

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReconnectTimeout() {
        return this.reconnectTimeout;
    }

    public void setReconnectTimeout(int reconnectTimeout) {
        this.reconnectTimeout = reconnectTimeout;
    }

    public void setReconnecting(boolean reconnecting) {
        this.reconnecting = reconnecting;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
        if (this.tcpNetworkConnection != null) {
            this.tcpNetworkConnection.setExecutor(executor);
        }
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public Integer getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(Integer localPort) {
        this.localPort = localPort;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.address == null) {
            throw new IllegalArgumentException("Property 'address' is required");
        }
        if (this.port == null) {
            throw new IllegalArgumentException("Property 'port' is required");
        }
        this.active = true;
        this.reconnect();
    }

    protected Socket openSocket() throws Exception {
        InetSocketAddress socketAddress = new InetSocketAddress(this.address, (int)this.port);
        Socket socket = new Socket();
        if (this.getLocalAddress() != null) {
            if (this.getLocalPort() != null) {
                socket.bind(new InetSocketAddress(this.getLocalAddress(), (int)this.getLocalPort()));
            } else {
                socket.bind(new InetSocketAddress(this.getLocalAddress(), 0));
            }
        }
        socket.connect(socketAddress, this.connectTimeout);
        return socket;
    }

    protected TcpNetworkConnection openTcpNetworkConnection(Socket socket) throws Exception {
        return new TcpNetworkConnection(socket);
    }

    private String getConnectionName() {
        StringBuilder connectionName = new StringBuilder();
        connectionName.append("[");
        if (this.getLocalAddress() != null) {
            connectionName.append(this.getLocalAddress());
        } else {
            connectionName.append("::");
        }
        connectionName.append("]:");
        if (this.getLocalPort() != null) {
            connectionName.append(this.getLocalPort());
        } else {
            connectionName.append("0");
        }
        connectionName.append(" -> ");
        connectionName.append("[");
        connectionName.append(this.getAddress());
        connectionName.append("]:");
        connectionName.append(this.getPort());
        return connectionName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect() {
        Object object = this.reconnectingMonitor;
        synchronized (object) {
            if (!this.active) {
                return;
            }
            if (this.tcpNetworkConnection != null) {
                return;
            }
            if (this.reconnecting) {
                return;
            }
            this.reconnecting = true;
            final String connectionName = this.getConnectionName();
            Thread reconnectThread = new Thread("Reconnect thread for " + connectionName){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (TcpNetworkClient.this.active) {
                        Socket socket = null;
                        try {
                            LOGGER.debug("Connecting to {}", (Object)connectionName);
                            socket = TcpNetworkClient.this.openSocket();
                            TcpNetworkClient.this.tcpNetworkConnection = TcpNetworkClient.this.openTcpNetworkConnection(socket);
                            TcpNetworkClient.this.tcpNetworkConnection.setNetworkMessageHandler(TcpNetworkClient.this.networkMessageHandler);
                            TcpNetworkClient.this.tcpNetworkConnection.setExecutor(TcpNetworkClient.this.executor);
                            TcpNetworkClient.this.tcpNetworkConnection.setMaxMessageSize(TcpNetworkClient.this.getMaxMessageSize());
                            TcpNetworkClient.this.tcpNetworkConnection.setChunkSize(TcpNetworkClient.this.getChunkSize());
                            TcpNetworkClient.this.tcpNetworkConnection.setDisconnectListener(new DisconnectListener(){

                                @Override
                                public void disconnected(TcpNetworkConnection nc) {
                                    TcpNetworkClient.this.tcpNetworkConnection = null;
                                    TcpNetworkClient.this.reconnect();
                                }
                            });
                            TcpNetworkClient.this.tcpNetworkConnection.open();
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Connected from [{}]:{} to [{}]:{}", new Object[]{socket.getLocalAddress().getHostAddress(), socket.getLocalPort(), socket.getInetAddress().getHostAddress(), socket.getPort()});
                            }
                            TcpNetworkClient.this.reconnecting = false;
                            Object object = TcpNetworkClient.this.connectedMonitor;
                            synchronized (object) {
                                TcpNetworkClient.this.connectedMonitor.notifyAll();
                                break;
                            }
                        }
                        catch (Throwable e) {
                            TcpNetworkClient.this.tcpNetworkConnection = null;
                            CloseUtil.close((Closeable[])new Closeable[]{socket});
                            LOGGER.debug("Error connection to " + connectionName, e);
                            try {
                                Thread.sleep(TcpNetworkClient.this.getReconnectTimeout());
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                }
            };
            reconnectThread.setDaemon(true);
            reconnectThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        LOGGER.debug("Disconnecting from {}", (Object)this.getConnectionName());
        this.active = false;
        CloseUtil.close((Closeable[])new Closeable[]{this.tcpNetworkConnection});
        Object object = this.connectedMonitor;
        synchronized (object) {
            this.connectedMonitor.notifyAll();
        }
    }

    @Override
    public void sendMessage(Object object) throws NetworkException {
        if (!this.isConnectionEstablished()) {
            throw new NetworkException("Not connected");
        }
        try {
            this.tcpNetworkConnection.sendMessage(object);
        }
        catch (NetworkException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NetworkException("Error sending message", e);
        }
    }

    @Override
    public void sendMessage(byte[] data) throws NetworkException {
        if (!this.isConnectionEstablished()) {
            throw new NetworkException("Not connected");
        }
        try {
            this.tcpNetworkConnection.sendMessage(data);
        }
        catch (NetworkException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NetworkException("Error sending message", e);
        }
    }

    @Override
    public void setNetworkMessageHandler(NetworkMessageHandler networkMessageHandler) {
        this.networkMessageHandler = networkMessageHandler;
        if (this.tcpNetworkConnection != null) {
            this.tcpNetworkConnection.setNetworkMessageHandler(networkMessageHandler);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isConnectionEstablished() {
        if (!this.active) {
            return false;
        }
        try {
            if (this.tcpNetworkConnection != null) {
                return this.tcpNetworkConnection.isConnectionEstablished();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForConnection(long waitTime) {
        if (!this.active) {
            return false;
        }
        if (waitTime > 0L) {
            long sleepTime;
            long waitUntil = System.currentTimeMillis() + waitTime;
            while (!this.isConnectionEstablished() && (sleepTime = waitUntil - System.currentTimeMillis()) > 0L) {
                Object object = this.connectedMonitor;
                synchronized (object) {
                    try {
                        this.connectedMonitor.wait(sleepTime);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return this.isConnectionEstablished();
    }

    public long getLastActivityAt() {
        if (this.tcpNetworkConnection != null) {
            return this.tcpNetworkConnection.getLastActivityAt();
        }
        return Long.MIN_VALUE;
    }

    public Socket getSocket() {
        if (this.tcpNetworkConnection != null) {
            return this.tcpNetworkConnection.getSocket();
        }
        return null;
    }
}

