/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.tcp;

import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.Vector;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DefaultTlsServer;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedDecryptor;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.ssl.BcKeyManager;
import si.nevensrok.common.ssl.BcTrustManager;

public class CustomTlsServer
extends DefaultTlsServer {
    private static final Logger log = LoggerFactory.getLogger(CustomTlsServer.class);
    private BcTrustManager trustManager;
    private BcKeyManager keyManager;
    private TlsCertificate clientCertificate;
    private boolean sslSessionValid = false;

    public CustomTlsServer() {
        super((TlsCrypto)new BcTlsCrypto(new SecureRandom()));
    }

    public void notifyHandshakeComplete() throws IOException {
        this.sslSessionValid = true;
    }

    public boolean isSslSessionValid() {
        return this.sslSessionValid;
    }

    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        log.trace("NotifyAlertRaised: " + message, cause);
    }

    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        log.trace("NotifyAlertReceived");
    }

    public void notifySecureRenegotiation(boolean secureRenegotiation) throws IOException {
    }

    public void setTrustManager(BcTrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public void setKeyManager(BcKeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public TlsCertificate getClientCertificate() {
        return this.clientCertificate;
    }

    public void setClientCertificate(TlsCertificate clientCertificate) {
        this.clientCertificate = clientCertificate;
    }

    public CertificateRequest getCertificateRequest() throws IOException {
        try {
            Vector<X500Name> certificateAuthorities = new Vector<X500Name>();
            if (this.trustManager != null) {
                for (org.bouncycastle.asn1.x509.Certificate certificate : this.trustManager.getAcceptedIssuers()) {
                    certificateAuthorities.addElement(certificate.getSubject());
                }
            }
            Vector serverSigAlgs = null;
            for (ProtocolVersion protocolVersion : this.getProtocolVersions()) {
                if (!TlsUtils.isSignatureAlgorithmsExtensionAllowed((ProtocolVersion)protocolVersion)) continue;
                serverSigAlgs = TlsUtils.getDefaultSupportedSignatureAlgorithms((TlsContext)this.context);
                break;
            }
            return new CertificateRequest(new short[]{1, 2, 64}, serverSigAlgs, certificateAuthorities);
        }
        catch (Exception e) {
            log.error("Error loading certificate data", (Throwable)e);
            throw new IOException("Certificate request loading failed");
        }
    }

    protected TlsCredentialedDecryptor getRSAEncryptionCredentials() throws IOException {
        try {
            String alias;
            if (this.keyManager != null && (alias = this.keyManager.chooseAlias("RSA")) != null) {
                BcTlsCertificate[] certificateChain = this.keyManager.getCertificateChain(alias);
                AsymmetricKeyParameter privateKey = this.keyManager.getPrivateKey(alias);
                Certificate certificate = new Certificate((TlsCertificate[])certificateChain);
                BcTlsCrypto bcTlsCrypto = (BcTlsCrypto)this.context.getCrypto();
                return new BcDefaultTlsCredentialedDecryptor(bcTlsCrypto, certificate, privateKey);
            }
        }
        catch (Exception e) {
            log.error("Error loading rsa encryption credentials", (Throwable)e);
        }
        throw new IOException("RSA certificate not found");
    }

    protected TlsCredentialedSigner getRSASignerCredentials() throws IOException {
        try {
            String alias;
            if (this.keyManager != null && (alias = this.keyManager.chooseAlias("RSA")) != null) {
                BcTlsCertificate[] certificateChain = this.keyManager.getCertificateChain(alias);
                AsymmetricKeyParameter privateKey = this.keyManager.getPrivateKey(alias);
                Certificate certificate = new Certificate((TlsCertificate[])certificateChain);
                SignatureAndHashAlgorithm signatureAndHashAlgorithm = this.getSignatureAndHashAlgorithm(certificateChain[0]);
                BcTlsCrypto bcTlsCrypto = (BcTlsCrypto)this.context.getCrypto();
                return new BcDefaultTlsCredentialedSigner(new TlsCryptoParameters((TlsContext)this.context), bcTlsCrypto, privateKey, certificate, signatureAndHashAlgorithm);
            }
        }
        catch (Exception e) {
            log.error("Error loading rsa signer credentials", (Throwable)e);
        }
        throw new IOException("RSA certificate not found");
    }

    protected TlsCredentialedSigner getDSASignerCredentials() throws IOException {
        try {
            String alias;
            if (this.keyManager != null && (alias = this.keyManager.chooseAlias("DSA")) != null) {
                BcTlsCertificate[] certificateChain = this.keyManager.getCertificateChain(alias);
                AsymmetricKeyParameter privateKey = this.keyManager.getPrivateKey(alias);
                Certificate certificate = new Certificate((TlsCertificate[])certificateChain);
                SignatureAndHashAlgorithm signatureAndHashAlgorithm = this.getSignatureAndHashAlgorithm(certificateChain[0]);
                BcTlsCrypto bcTlsCrypto = (BcTlsCrypto)this.context.getCrypto();
                return new BcDefaultTlsCredentialedSigner(new TlsCryptoParameters((TlsContext)this.context), bcTlsCrypto, privateKey, certificate, signatureAndHashAlgorithm);
            }
        }
        catch (Exception e) {
            log.error("Error loading dsa signer credentials", (Throwable)e);
        }
        throw new IOException("DSA certificate not found");
    }

    protected TlsCredentialedSigner getECDSASignerCredentials() throws IOException {
        try {
            String alias;
            if (this.keyManager != null && (alias = this.keyManager.chooseAlias("EC")) != null) {
                BcTlsCertificate[] certificateChain = this.keyManager.getCertificateChain(alias);
                AsymmetricKeyParameter privateKey = this.keyManager.getPrivateKey(alias);
                Certificate certificate = new Certificate((TlsCertificate[])certificateChain);
                SignatureAndHashAlgorithm signatureAndHashAlgorithm = this.getSignatureAndHashAlgorithm(certificateChain[0]);
                BcTlsCrypto bcTlsCrypto = (BcTlsCrypto)this.context.getCrypto();
                return new BcDefaultTlsCredentialedSigner(new TlsCryptoParameters((TlsContext)this.context), bcTlsCrypto, privateKey, certificate, signatureAndHashAlgorithm);
            }
        }
        catch (Exception e) {
            log.error("Error loading ecdsa signer credentials", (Throwable)e);
        }
        throw new IOException("EC certificate not found");
    }

    public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        if (clientCertificate == null || clientCertificate.getCertificateList().length == 0) {
            return;
        }
        if (this.trustManager != null) {
            try {
                this.trustManager.checkCertificateTrusted(clientCertificate.getCertificateList());
                this.setClientCertificate(clientCertificate.getCertificateList()[0]);
            }
            catch (CertificateException e) {
                throw new IOException("Client certificate validation failed");
            }
        } else {
            throw new IOException("Client certificate validation failed");
        }
    }

    public void processClientSupplementalData(Vector clientSupplementalData) throws IOException {
    }

    protected SignatureAndHashAlgorithm getSignatureAndHashAlgorithm(BcTlsCertificate certificate) {
        String algorithmIdentifier = certificate.getSigAlgOID();
        if ("1.2.840.113549.1.1.4".equals(algorithmIdentifier)) {
            return new SignatureAndHashAlgorithm(1, 1);
        }
        if ("1.2.840.113549.1.1.5".equals(algorithmIdentifier)) {
            return new SignatureAndHashAlgorithm(2, 1);
        }
        if ("1.2.840.113549.1.1.11".equals(algorithmIdentifier)) {
            return new SignatureAndHashAlgorithm(4, 1);
        }
        if ("1.2.840.113549.1.1.12".equals(algorithmIdentifier)) {
            return new SignatureAndHashAlgorithm(5, 1);
        }
        if ("1.2.840.113549.1.1.13".equals(algorithmIdentifier)) {
            return new SignatureAndHashAlgorithm(6, 1);
        }
        if ("1.2.840.113549.1.1.14".equals(algorithmIdentifier)) {
            return new SignatureAndHashAlgorithm(3, 1);
        }
        throw new IllegalArgumentException("Unsupported signature algorithm: " + algorithmIdentifier);
    }
}

