/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ldap;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.ldap.LdapAuthenticationClient;
import si.nevensrok.common.ldap.LdapClientImpl;
import si.nevensrok.common.ldap.LdapUtil;
import si.nevensrok.common.utils.PlaceholderUtil;

public class LdapAuthenticationClientImpl
extends LdapClientImpl
implements LdapAuthenticationClient {
    private static final Logger log = LoggerFactory.getLogger(LdapAuthenticationClientImpl.class);
    private String authSearchFilter = "objectClass=inetOrgPerson";
    private String usernameAttribute = "uid";
    private String passwordAttribute = "userpassword";
    private Map<String, String> additionalFilters = null;
    private boolean checkPasswordViaAuth = true;

    public void setAuthSearchFilter(String authSearchFilter) {
        this.authSearchFilter = authSearchFilter;
    }

    public void setUsernameAttribute(String usernameAttribute) {
        this.usernameAttribute = usernameAttribute;
    }

    public void setPasswordAttribute(String passwordAttribute) {
        this.passwordAttribute = passwordAttribute;
    }

    public void setAdditionalFilters(Map<String, String> additionalFilters) {
        this.additionalFilters = additionalFilters;
    }

    public void setCheckPasswordViaAuth(boolean checkPasswordViaAuth) {
        this.checkPasswordViaAuth = checkPasswordViaAuth;
    }

    @Override
    public boolean authenticateUser(String username, String password) {
        if (username == null || username.isEmpty() || password == null || password.isEmpty()) {
            return false;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("username", username);
        placeholders.put("password", password);
        String userSearchFilter = PlaceholderUtil.replacePlaceHolders((String)this.authSearchFilter, placeholders, (String)"{", (String)"}");
        List<SearchResult> users = this.search(userSearchFilter);
        log.trace("Users found by filter: {}", (Object)users.size());
        for (SearchResult searchResult : users) {
            log.trace("Cheking: {}", (Object)searchResult.getName());
            try {
                String resultUsername = this.getAttributeAsString(searchResult, this.usernameAttribute);
                if (resultUsername == null || !resultUsername.equals(username)) continue;
                log.trace("Find username: {}", (Object)resultUsername);
                if (this.additionalFilters != null && !this.additionalFilters.isEmpty()) {
                    boolean matchesAdditionalFilters = true;
                    for (Map.Entry<String, String> entry : this.additionalFilters.entrySet()) {
                        boolean matchesAtLeastOne = false;
                        List<Object> values = LdapUtil.getAttributeValues(searchResult, entry.getKey());
                        if (values != null) {
                            for (Object attributeValue : values) {
                                if (attributeValue == null || !(attributeValue instanceof String) || !((String)attributeValue).matches(entry.getValue())) continue;
                                matchesAtLeastOne = true;
                                break;
                            }
                        }
                        if (matchesAtLeastOne) continue;
                        matchesAdditionalFilters = false;
                        break;
                    }
                    if (!matchesAdditionalFilters) continue;
                }
                if (this.checkPasswordViaAuth) {
                    String dn = searchResult.getNameInNamespace();
                    log.trace("DN: {}", (Object)dn);
                    Hashtable<String, String> env = new Hashtable<String, String>();
                    env.put("java.naming.security.authentication", "simple");
                    env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                    env.put("java.naming.provider.url", this.getProviderUrl());
                    env.put("java.naming.security.principal", dn);
                    env.put("java.naming.security.credentials", password);
                    Context ldapContext = null;
                    try {
                        ldapContext = new InitialLdapContext(env, null);
                        ldapContext.close();
                        return true;
                    }
                    catch (Exception e) {
                        try {
                            ldapContext.close();
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                }
                String resultPassword = this.getAttributeAsString(searchResult, this.passwordAttribute);
                if (resultPassword == null || !LdapUtil.checkPassword(password, resultPassword)) continue;
                return true;
            }
            catch (Exception e) {
                log.error("Error cheking authentication for user", (Throwable)e);
            }
        }
        return false;
    }

    private String getAttributeAsString(SearchResult searchResult, String attributeName) {
        try {
            Object value = LdapUtil.getAttributeValue(searchResult, attributeName);
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof byte[]) {
                return new String((byte[])value, "UTF-8");
            }
        }
        catch (Exception e) {
            log.error("Error fetching attribute", (Throwable)e);
        }
        return null;
    }
}

