/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.bccert;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.net.InetAddress;
import java.security.InvalidKeyException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.MD2Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DSAKeyParameters;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import si.nevensrok.common.utils.ByteUtil;
import si.nevensrok.common.utils.HashUtil;
import si.nevensrok.common.x509cert.CertificateInformation;

public class BcCertificateUtil {
    public static CertificateInformation getCertificateInfo(Certificate certificate) {
        try {
            CertificateInformation certificateInfo = new CertificateInformation();
            X500Name name = certificate.getSubject();
            String country = null;
            String state = null;
            String city = null;
            String organization = null;
            String organizationalUnit = null;
            String commonName = null;
            String domain = null;
            String ip = null;
            for (RDN rdn : name.getRDNs()) {
                AttributeTypeAndValue attributeTypeAndValue = rdn.getFirst();
                if (RFC4519Style.c.getId().equals(attributeTypeAndValue.getType().getId())) {
                    country = BcCertificateUtil.getStringValue(attributeTypeAndValue.getValue());
                    continue;
                }
                if (RFC4519Style.st.getId().equals(attributeTypeAndValue.getType().getId())) {
                    state = BcCertificateUtil.getStringValue(attributeTypeAndValue.getValue());
                    continue;
                }
                if (RFC4519Style.l.getId().equals(attributeTypeAndValue.getType().getId())) {
                    city = BcCertificateUtil.getStringValue(attributeTypeAndValue.getValue());
                    continue;
                }
                if (RFC4519Style.o.getId().equals(attributeTypeAndValue.getType().getId())) {
                    organization = BcCertificateUtil.getStringValue(attributeTypeAndValue.getValue());
                    continue;
                }
                if (RFC4519Style.ou.getId().equals(attributeTypeAndValue.getType().getId())) {
                    organizationalUnit = BcCertificateUtil.getStringValue(attributeTypeAndValue.getValue());
                    continue;
                }
                if (RFC4519Style.cn.getId().equals(attributeTypeAndValue.getType().getId())) {
                    commonName = BcCertificateUtil.getStringValue(attributeTypeAndValue.getValue());
                    continue;
                }
                if (RFC4519Style.uid.getId().equals(attributeTypeAndValue.getType().getId())) {
                    domain = BcCertificateUtil.getStringValue(attributeTypeAndValue.getValue());
                    continue;
                }
                if (!"1.3.6.1.4.1.42.2.11.2.1".equals(attributeTypeAndValue.getType().getId())) continue;
                ip = BcCertificateUtil.getStringValue(attributeTypeAndValue.getValue());
            }
            SubjectPublicKeyInfo subjectPublicKeyInfo = certificate.getTBSCertificate().getSubjectPublicKeyInfo();
            AsymmetricKeyParameter publicKey = PublicKeyFactory.createKey((SubjectPublicKeyInfo)subjectPublicKeyInfo);
            int keySize = 0;
            String keyAlgorithm = null;
            if (publicKey instanceof RSAKeyParameters) {
                keySize = ((RSAKeyParameters)publicKey).getModulus().bitLength();
                keyAlgorithm = "RSA";
            } else if (publicKey instanceof DSAKeyParameters) {
                keySize = ((DSAKeyParameters)publicKey).getParameters().getP().bitLength();
                keyAlgorithm = "DSA";
            } else if (publicKey instanceof ECKeyParameters) {
                keySize = ((ECKeyParameters)publicKey).getParameters().getN().bitLength();
                keyAlgorithm = "EC";
            }
            boolean signing = false;
            boolean ca = false;
            int certificationPathLength = -1;
            LinkedList<String> alternativeNames = new LinkedList<String>();
            try {
                Extensions extensions = certificate.getTBSCertificate().getExtensions();
                if (extensions != null) {
                    ASN1Encodable subjectAlternativeName;
                    BasicConstraints basicConstraints;
                    KeyUsage keyUsage = KeyUsage.fromExtensions((Extensions)extensions);
                    if (keyUsage != null) {
                        int bits = keyUsage.getBytes()[0] & 0xFF;
                        boolean bl = signing = (bits & 4) > 0;
                    }
                    if ((basicConstraints = BasicConstraints.fromExtensions((Extensions)extensions)) != null) {
                        ca = basicConstraints.isCA();
                        BigInteger pathLenConstraint = basicConstraints.getPathLenConstraint();
                        if (pathLenConstraint != null) {
                            certificationPathLength = pathLenConstraint.intValue();
                        }
                    }
                    if ((subjectAlternativeName = extensions.getExtensionParsedValue(Extension.subjectAlternativeName)) instanceof ASN1Sequence) {
                        ASN1Sequence subjectAlternativeNameSequence = (ASN1Sequence)subjectAlternativeName;
                        Enumeration en = subjectAlternativeNameSequence.getObjects();
                        while (en.hasMoreElements()) {
                            GeneralName generalName = GeneralName.getInstance(en.nextElement());
                            String value = null;
                            if (generalName.getTagNo() == 1 || generalName.getTagNo() == 2 || generalName.getTagNo() == 6) {
                                value = BcCertificateUtil.getStringValue(generalName.getName());
                            } else if (generalName.getTagNo() == 7) {
                                byte[] ipBytes = DEROctetString.getInstance((Object)generalName.getName()).getOctets();
                                try {
                                    value = InetAddress.getByAddress(ipBytes).getHostAddress();
                                }
                                catch (Exception exception) {}
                            } else if (generalName.getTagNo() == 8) {
                                value = ASN1ObjectIdentifier.getInstance((Object)generalName.getName()).getId();
                            }
                            if (value == null) continue;
                            alternativeNames.add(value);
                        }
                    }
                }
            }
            catch (Exception extensions) {
                // empty catch block
            }
            X500Name issuerName = certificate.getIssuer();
            String issuerCountry = null;
            String issuerState = null;
            String issuerCity = null;
            String issuerOrganization = null;
            String issuerOrganizationalUnit = null;
            String issuerCommonName = null;
            for (RDN rdn : issuerName.getRDNs()) {
                AttributeTypeAndValue attributeTypeAndValue = rdn.getFirst();
                if (RFC4519Style.c.getId().equals(attributeTypeAndValue.getType().getId())) {
                    issuerCountry = BcCertificateUtil.getStringValue(attributeTypeAndValue.getValue());
                    continue;
                }
                if (RFC4519Style.st.getId().equals(attributeTypeAndValue.getType().getId())) {
                    issuerState = BcCertificateUtil.getStringValue(attributeTypeAndValue.getValue());
                    continue;
                }
                if (RFC4519Style.l.getId().equals(attributeTypeAndValue.getType().getId())) {
                    issuerCity = BcCertificateUtil.getStringValue(attributeTypeAndValue.getValue());
                    continue;
                }
                if (RFC4519Style.o.getId().equals(attributeTypeAndValue.getType().getId())) {
                    issuerOrganization = BcCertificateUtil.getStringValue(attributeTypeAndValue.getValue());
                    continue;
                }
                if (RFC4519Style.ou.getId().equals(attributeTypeAndValue.getType().getId())) {
                    issuerOrganizationalUnit = BcCertificateUtil.getStringValue(attributeTypeAndValue.getValue());
                    continue;
                }
                if (!RFC4519Style.cn.getId().equals(attributeTypeAndValue.getType().getId())) continue;
                issuerCommonName = BcCertificateUtil.getStringValue(attributeTypeAndValue.getValue());
            }
            certificateInfo.setSerialNumber(certificate.getSerialNumber().getValue());
            certificateInfo.setVersion(certificate.getVersionNumber());
            certificateInfo.setValidFrom(certificate.getStartDate().getDate());
            certificateInfo.setValidUntil(certificate.getEndDate().getDate());
            certificateInfo.setCountry(country);
            certificateInfo.setState(state);
            certificateInfo.setCity(city);
            certificateInfo.setOrganization(organization);
            certificateInfo.setOrganizationUnit(organizationalUnit);
            certificateInfo.setCommonName(commonName);
            certificateInfo.setDomain(domain);
            certificateInfo.setIp(ip);
            certificateInfo.setAlternativeNames(alternativeNames);
            certificateInfo.setSignatureAlgorithm(BcCertificateUtil.getSignatureAlgorithmText(certificate.getSignatureAlgorithm()));
            certificateInfo.setIsUsedForSigning(signing);
            certificateInfo.setIsCa(ca);
            certificateInfo.setCertificationPathLength(certificationPathLength);
            certificateInfo.setMd5fingerprint(ByteUtil.toHexString((byte[])BcCertificateUtil.getMD5Fingerprint(certificate)));
            certificateInfo.setSha1fingerprint(ByteUtil.toHexString((byte[])BcCertificateUtil.getSHA1Fingerprint(certificate)));
            certificateInfo.setSha256fingerprint(ByteUtil.toHexString((byte[])BcCertificateUtil.getSHA256Fingerprint(certificate)));
            certificateInfo.setKeySize(keySize);
            certificateInfo.setKeyAlgorithm(keyAlgorithm);
            certificateInfo.setIssuerCountry(issuerCountry);
            certificateInfo.setIssuerState(issuerState);
            certificateInfo.setIssuerCity(issuerCity);
            certificateInfo.setIssuerOrganization(issuerOrganization);
            certificateInfo.setIssuerOrganizationUnit(issuerOrganizationalUnit);
            certificateInfo.setIssuerCommonName(issuerCommonName);
            return certificateInfo;
        }
        catch (Exception e) {
            throw new RuntimeException("Error extracting certificate information", e);
        }
    }

    public static Certificate loadCertificate(InputStream inputStream) {
        try {
            PemObject pemObject = BcCertificateUtil.readPemObject(inputStream);
            if (pemObject.getType().endsWith("CERTIFICATE")) {
                Certificate certificate = Certificate.getInstance((Object)pemObject.getContent());
                return certificate;
            }
            throw new IOException("Invalid object type: " + pemObject.getType());
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading certificate", e);
        }
    }

    public static void saveCertificate(Certificate certificate, OutputStream outputStream) {
        try {
            outputStream.write(certificate.getEncoded());
        }
        catch (Exception e) {
            throw new RuntimeException("Error saving certificate", e);
        }
    }

    public static void saveCertificateAsBase64(Certificate certificate, OutputStream outputStream) {
        try {
            String base64 = ByteUtil.toBase64String((byte[])certificate.getEncoded());
            outputStream.write("-----BEGIN CERTIFICATE-----\n".getBytes("ASCII"));
            outputStream.write(base64.getBytes("ASCII"));
            outputStream.write("\n-----END CERTIFICATE-----\n".getBytes("ASCII"));
        }
        catch (Exception e) {
            throw new RuntimeException("Error saving certificate", e);
        }
    }

    public static byte[] getMD5Fingerprint(Certificate certificate) {
        try {
            return HashUtil.generateHash((byte[])certificate.getEncoded(), (HashUtil.HashType)HashUtil.HashType.MD5);
        }
        catch (Exception e) {
            throw new RuntimeException("Error calculating certificate MD5 fingerprint", e);
        }
    }

    public static byte[] getSHA1Fingerprint(Certificate certificate) {
        try {
            return HashUtil.generateHash((byte[])certificate.getEncoded(), (HashUtil.HashType)HashUtil.HashType.SHA1);
        }
        catch (Exception e) {
            throw new RuntimeException("Error calculating certificate SHA1 fingerprint", e);
        }
    }

    public static byte[] getSHA256Fingerprint(Certificate certificate) {
        try {
            return HashUtil.generateHash((byte[])certificate.getEncoded(), (HashUtil.HashType)HashUtil.HashType.SHA256);
        }
        catch (Exception e) {
            throw new RuntimeException("Error calculating certificate SHA256 fingerprint", e);
        }
    }

    public static boolean isUsedForSigning(Certificate certificate) {
        KeyUsage keyUsage;
        Extensions extensions = certificate.getTBSCertificate().getExtensions();
        if (extensions != null && (keyUsage = KeyUsage.fromExtensions((Extensions)extensions)) != null) {
            int bits = keyUsage.getBytes()[0] & 0xFF;
            return (bits & 4) > 0;
        }
        return false;
    }

    public static String getKeyAlgorithm(Certificate certificate) {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = certificate.getTBSCertificate().getSubjectPublicKeyInfo();
            AsymmetricKeyParameter publicKey = PublicKeyFactory.createKey((SubjectPublicKeyInfo)subjectPublicKeyInfo);
            if (publicKey instanceof RSAKeyParameters) {
                return "RSA";
            }
            if (publicKey instanceof DSAKeyParameters) {
                return "DSA";
            }
            if (publicKey instanceof ECKeyParameters) {
                return "EC";
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Error extracting key type", e);
        }
    }

    public static List<String> getAlternativeNames(Certificate certificate) {
        LinkedList<String> alternativeNames = new LinkedList<String>();
        try {
            ASN1Encodable subjectAlternativeName;
            Extensions extensions = certificate.getTBSCertificate().getExtensions();
            if (extensions != null && (subjectAlternativeName = extensions.getExtensionParsedValue(Extension.subjectAlternativeName)) instanceof ASN1Sequence) {
                ASN1Sequence subjectAlternativeNameSequence = (ASN1Sequence)subjectAlternativeName;
                Enumeration en = subjectAlternativeNameSequence.getObjects();
                while (en.hasMoreElements()) {
                    GeneralName generalName = GeneralName.getInstance(en.nextElement());
                    String value = null;
                    if (generalName.getTagNo() == 1 || generalName.getTagNo() == 2 || generalName.getTagNo() == 6) {
                        value = BcCertificateUtil.getStringValue(generalName.getName());
                    } else if (generalName.getTagNo() == 7) {
                        byte[] ipBytes = DEROctetString.getInstance((Object)generalName.getName()).getOctets();
                        try {
                            value = InetAddress.getByAddress(ipBytes).getHostAddress();
                        }
                        catch (Exception exception) {}
                    } else if (generalName.getTagNo() == 8) {
                        value = ASN1ObjectIdentifier.getInstance((Object)generalName.getName()).getId();
                    }
                    if (value == null) continue;
                    alternativeNames.add(value);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return alternativeNames;
    }

    public static String getCommonName(Certificate certificate) {
        X500Name name = certificate.getSubject();
        for (RDN rdn : name.getRDNs()) {
            AttributeTypeAndValue attributeTypeAndValue = rdn.getFirst();
            if (!RFC4519Style.cn.getId().equals(attributeTypeAndValue.getType().getId())) continue;
            return BcCertificateUtil.getStringValue(attributeTypeAndValue.getValue());
        }
        return null;
    }

    public static void checkCertificateDate(Certificate certificate) throws CertificateExpiredException, CertificateNotYetValidException {
        BcCertificateUtil.checkCertificateDate(certificate, Calendar.getInstance().getTime());
    }

    public static void checkCertificateDate(Certificate certificate, Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (certificate.getStartDate().getDate().after(date)) {
            throw new CertificateNotYetValidException();
        }
        if (certificate.getEndDate().getDate().before(date)) {
            throw new CertificateExpiredException();
        }
    }

    public static void verifyCertificate(Certificate certificate, Certificate validateWith) throws CertificateException, InvalidKeyException, SignatureException, IOException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = validateWith.getTBSCertificate().getSubjectPublicKeyInfo();
        AsymmetricKeyParameter publicKey = PublicKeyFactory.createKey((SubjectPublicKeyInfo)subjectPublicKeyInfo);
        BcCertificateUtil.verifyCertificate(certificate, publicKey);
    }

    public static void verifyCertificate(Certificate certificate, AsymmetricKeyParameter publicKey) throws CertificateException, InvalidKeyException, SignatureException, IOException {
        MD2Digest digest;
        byte[] certificateBytes = certificate.getTBSCertificate().getEncoded();
        byte[] signatureBytes = certificate.getSignature().getBytes();
        AlgorithmIdentifier signatureAlgorithmIdentifier = certificate.getSignatureAlgorithm();
        if ("1.2.840.113549.1.1.2".equals(signatureAlgorithmIdentifier.getAlgorithm().getId())) {
            digest = new MD2Digest();
        } else if ("1.2.840.113549.1.1.4".equals(signatureAlgorithmIdentifier.getAlgorithm().getId())) {
            digest = new MD5Digest();
        } else if ("1.2.840.113549.1.1.5".equals(signatureAlgorithmIdentifier.getAlgorithm().getId())) {
            digest = new SHA1Digest();
        } else if ("1.2.840.113549.1.1.11".equals(signatureAlgorithmIdentifier.getAlgorithm().getId())) {
            digest = new SHA256Digest();
        } else if ("1.2.840.113549.1.1.12".equals(signatureAlgorithmIdentifier.getAlgorithm().getId())) {
            digest = new SHA384Digest();
        } else if ("1.2.840.113549.1.1.13".equals(signatureAlgorithmIdentifier.getAlgorithm().getId())) {
            digest = new SHA512Digest();
        } else if ("1.2.840.113549.1.1.14".equals(signatureAlgorithmIdentifier.getAlgorithm().getId())) {
            digest = new SHA224Digest();
        } else {
            throw new SignatureException("Unsupported sinature algorithm");
        }
        RSADigestSigner signer = new RSADigestSigner((Digest)digest);
        if (publicKey instanceof RSAKeyParameters) {
            RSAKeyParameters rsaKeyParameters = (RSAKeyParameters)publicKey;
            signer.init(false, (CipherParameters)rsaKeyParameters);
            signer.update(certificateBytes, 0, certificateBytes.length);
            if (!signer.verifySignature(signatureBytes)) {
                throw new CertificateException("Invalid signature");
            }
        } else {
            throw new InvalidKeyException("Public key is not of type RSA");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PemObject readPemObject(InputStream inputStream) throws IOException {
        PemReader pemReader = null;
        try {
            pemReader = new PemReader((Reader)new InputStreamReader(inputStream));
            PemObject pemObject = pemReader.readPemObject();
            return pemObject;
        }
        finally {
            try {
                pemReader.close();
            }
            catch (Exception exception) {}
        }
    }

    private static String getStringValue(ASN1Encodable asn1Encodable) {
        if (asn1Encodable instanceof DERPrintableString) {
            return ((DERPrintableString)asn1Encodable).getString();
        }
        if (asn1Encodable instanceof DERUTF8String) {
            return ((DERUTF8String)asn1Encodable).getString();
        }
        if (asn1Encodable instanceof DERIA5String) {
            return ((DERIA5String)asn1Encodable).getString();
        }
        return null;
    }

    private static String getSignatureAlgorithmText(AlgorithmIdentifier algorithmIdentifier) {
        if ("1.2.840.113549.1.1.1".equals(algorithmIdentifier.getAlgorithm().getId())) {
            return "RSA";
        }
        if ("1.2.840.113549.1.1.2".equals(algorithmIdentifier.getAlgorithm().getId())) {
            return "MD2withRSA";
        }
        if ("1.2.840.113549.1.1.4".equals(algorithmIdentifier.getAlgorithm().getId())) {
            return "MD5withRSA";
        }
        if ("1.2.840.113549.1.1.5".equals(algorithmIdentifier.getAlgorithm().getId())) {
            return "SHA1withRSA";
        }
        if ("1.2.840.113549.1.1.11".equals(algorithmIdentifier.getAlgorithm().getId())) {
            return "SHA256withRSA";
        }
        if ("1.2.840.113549.1.1.12".equals(algorithmIdentifier.getAlgorithm().getId())) {
            return "SHA384withRSA";
        }
        if ("1.2.840.113549.1.1.13".equals(algorithmIdentifier.getAlgorithm().getId())) {
            return "SHA512withRSA";
        }
        if ("1.2.840.113549.1.1.14".equals(algorithmIdentifier.getAlgorithm().getId())) {
            return "SHA224withRSA";
        }
        return null;
    }
}

