
/* Drop */

DROP TRIGGER testlogid;
DROP TABLE IF EXISTS testlog;
DROP SEQUENCE IF EXISTS testlog_seq;



/* Create */

CREATE TABLE testlog
(
	Id NUMBER(38) NOT NULL,
	EventDate TIMESTAMP NOT NULL,
	ThreadName NVARCHAR2(1024) NOT NULL,
	Category NVARCHAR2(1024) NOT NULL,
	LogLevel NVARCHAR2(10) NOT NULL,
	Message NCLOB NOT NULL,
	Throwable NCLOB,
	LocationClassName NVARCHAR2(1024) NOT NULL,
	LocationMethodName NVARCHAR2(256) NOT NULL,
	LocationLineNumber NVARCHAR2(10) NOT NULL,
	MachineIp4 NVARCHAR2(15),
	MachineIp6 NVARCHAR2(45),
	MachineHostname NVARCHAR2(1024),
	MachineName NVARCHAR2(100),
	ProcessName NVARCHAR2(1024),
	PRIMARY KEY (Id)
);

--Sequence
create sequence testlog_seq minvalue 1 start with 1 increment by 1 cache 20;

--Trigger
CREATE OR REPLACE TRIGGER testlogid
BEFORE INSERT
	ON testlog
	FOR EACH ROW
DECLARE
	generatedid NUMBER(38);
BEGIN
	SELECT testlog_seq.nextval INTO generatedid from dual;
	:new.Id:=generatedid;
END;

/* Create indexes */
CREATE INDEX LogSearchIndex1 ON testlog (EventDate, LogLevel);

