/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.remoting;

import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ClassUtils;
import si.nevensrok.common.remoting.RemoteExecutionException;
import si.nevensrok.common.remoting.RemoteMethodInvocation;
import si.nevensrok.common.remoting.RemoteMethodInvocationResult;
import si.nevensrok.common.restclient.RestClient;
import si.nevensrok.common.restclient.RestClientUtil;
import si.nevensrok.common.restclient.RestRequest;
import si.nevensrok.common.restclient.RestResponse;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.common.utils.StringUtil;

public class HttpServiceProxyFactoryBean
implements FactoryBean<Object>,
MethodInterceptor,
InitializingBean {
    protected static final String CONTENT_TYPE = "application/x-java-serialized-object";
    private String endpoint;
    private String serviceName;
    private Class<?> serviceInterface;
    private RestClient restClient;
    private int connectTimeout = 10000;
    private int readTimeout = 60000;
    private Object serviceProxy;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Class<?> getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(Class<?> serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public void setRestClient(RestClient restClient) {
        this.restClient = restClient;
    }

    public RestClient getRestClient() {
        return this.restClient;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void afterPropertiesSet() {
        if (StringUtil.isEmpty((String)this.getEndpoint())) {
            throw new IllegalArgumentException("Property 'endpoint' is required");
        }
        if (StringUtil.isEmpty((String)this.getServiceName())) {
            throw new IllegalArgumentException("Property 'serviceName' is required");
        }
        if (this.getServiceInterface() == null) {
            throw new IllegalArgumentException("Property 'serviceInterface' is required");
        }
        if (this.restClient == null) {
            this.restClient = new RestClient();
            this.restClient.setConnectTimeout(this.getConnectTimeout());
            this.restClient.setReadTimeout(this.getReadTimeout());
        }
        this.serviceProxy = new ProxyFactory(this.getServiceInterface(), (Interceptor)this).getProxy(this.beanClassLoader);
    }

    public Object getObject() {
        return this.serviceProxy;
    }

    public Class<?> getObjectType() {
        return this.serviceInterface;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        Class<?>[] parameterTypes = invocation.getMethod().getParameterTypes();
        Object[] arguments = invocation.getArguments();
        RemoteMethodInvocation remoteMethodInvocation = new RemoteMethodInvocation();
        remoteMethodInvocation.setServiceName(this.getServiceName());
        remoteMethodInvocation.setMethodName(methodName);
        remoteMethodInvocation.setParameterTypes(parameterTypes);
        remoteMethodInvocation.setArguments(arguments);
        RestRequest restRequest = new RestRequest();
        restRequest.setUrl(this.getEndpoint());
        restRequest.setMethod("POST");
        restRequest.setContentType(CONTENT_TYPE);
        restRequest.setBody(ObjectUtil.serializeObject((Object)remoteMethodInvocation));
        RestResponse restResponse = this.getRestClient().execute(restRequest);
        if (restResponse.getResponseCode() != 200) {
            throw new RemoteExecutionException("Invalid response status " + restResponse.getResponseCode());
        }
        if (!CONTENT_TYPE.equalsIgnoreCase(RestClientUtil.extractMimeType((String)restResponse.getMimeType()))) {
            throw new RemoteExecutionException("Unsupported response content type");
        }
        RemoteMethodInvocationResult remoteMethodInvocationResult = (RemoteMethodInvocationResult)ObjectUtil.deserializeObject((byte[])restResponse.getBody());
        if (remoteMethodInvocationResult.getException() != null) {
            throw remoteMethodInvocationResult.getException();
        }
        return remoteMethodInvocationResult.getResult();
    }

    public boolean isSingleton() {
        return true;
    }
}

